/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.resource;

import com.azure.spring.cloud.core.resource.AzureStorageResource;
import com.azure.spring.cloud.core.resource.StorageType;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.options.BlockBlobOutputStreamOptions;
import com.azure.storage.blob.specialized.BlockBlobClient;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class StorageBlobResource
extends AzureStorageResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageBlobResource.class);
    private static final String MSG_FAIL_OPEN_OUTPUT = "Failed to open output stream of cloud blob";
    private static final String MSG_FAIL_OPEN_INPUT = "Failed to open input stream of blob";
    private final BlobServiceClient blobServiceClient;
    private final String location;
    private final BlobContainerClient blobContainerClient;
    private final BlockBlobClient blockBlobClient;
    private final boolean autoCreateFiles;
    private BlobProperties blobProperties;
    private final String snapshot;
    private final String versionId;
    private final String contentType;

    public StorageBlobResource(BlobServiceClient blobServiceClient, String location) {
        this(blobServiceClient, location, true);
    }

    public StorageBlobResource(BlobServiceClient blobServiceClient, String location, Boolean autoCreateFiles) {
        this(blobServiceClient, location, autoCreateFiles, null, null, null);
    }

    public StorageBlobResource(BlobServiceClient blobServiceClient, String location, Boolean autoCreateFiles, String snapshot, String versionId, String contentType) {
        this.assertIsAzureStorageLocation(location);
        this.autoCreateFiles = autoCreateFiles == null ? this.isAutoCreateFiles(location) : autoCreateFiles.booleanValue();
        this.blobServiceClient = blobServiceClient;
        this.location = location;
        this.snapshot = snapshot;
        this.versionId = versionId;
        this.contentType = StringUtils.hasText((String)contentType) ? contentType : this.getContentType(location);
        Assert.isTrue((!StringUtils.hasText((String)versionId) || !StringUtils.hasText((String)snapshot) ? 1 : 0) != 0, (String)"'versionId' and 'snapshot' can not be both set");
        this.blobContainerClient = blobServiceClient.getBlobContainerClient(this.getContainerName(location));
        BlobClient blobClient = this.blobContainerClient.getBlobClient(this.getFilename(location));
        if (StringUtils.hasText((String)versionId)) {
            blobClient = blobClient.getVersionClient(versionId);
        }
        if (StringUtils.hasText((String)snapshot)) {
            blobClient = blobClient.getSnapshotClient(snapshot);
        }
        this.blockBlobClient = blobClient.getBlockBlobClient();
    }

    private boolean isAutoCreateFiles(String location) {
        return true;
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            if (!this.exists()) {
                if (this.autoCreateFiles) {
                    this.create();
                } else {
                    throw new FileNotFoundException("The blob was not found: " + this.location);
                }
            }
            BlockBlobOutputStreamOptions options = new BlockBlobOutputStreamOptions();
            if (StringUtils.hasText((String)this.contentType)) {
                BlobHttpHeaders blobHttpHeaders = new BlobHttpHeaders();
                blobHttpHeaders.setContentType(this.contentType);
                options.setHeaders(blobHttpHeaders);
            }
            return this.blockBlobClient.getBlobOutputStream(options);
        }
        catch (BlobStorageException e) {
            throw new IOException(MSG_FAIL_OPEN_OUTPUT, e);
        }
    }

    public boolean exists() {
        return this.blobContainerClient.exists() && this.blockBlobClient.exists() != false;
    }

    public URL getURL() throws IOException {
        return new URL(this.blockBlobClient.getBlobUrl());
    }

    public File getFile() {
        throw new UnsupportedOperationException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    private BlobProperties getBlobProperties() {
        if (this.blobProperties == null) {
            this.blobProperties = this.blockBlobClient.getProperties();
        }
        return this.blobProperties;
    }

    public long contentLength() {
        return this.getBlobProperties().getBlobSize();
    }

    public long lastModified() {
        return this.getBlobProperties().getLastModified().toEpochSecond();
    }

    public Resource createRelative(String relativePath) {
        String newLocation = this.location + "/" + relativePath;
        return new StorageBlobResource(this.blobServiceClient, newLocation, this.autoCreateFiles);
    }

    public String getFilename() {
        return this.blockBlobClient.getBlobName();
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Azure storage account blob resource [container='");
        sb.append(this.blockBlobClient.getContainerName());
        sb.append("', blob='");
        sb.append(this.blockBlobClient.getBlobName());
        sb.append("'");
        if (this.versionId != null) {
            sb.append(", versionId='").append(this.versionId).append("'");
        }
        if (this.snapshot != null) {
            sb.append(", snapshot='").append(this.snapshot).append("'");
        }
        sb.append("]");
        return sb.toString();
    }

    public InputStream getInputStream() throws IOException {
        try {
            this.assertExisted();
            return this.blockBlobClient.openInputStream();
        }
        catch (BlobStorageException e) {
            throw new IOException(MSG_FAIL_OPEN_INPUT, e);
        }
    }

    @Override
    StorageType getStorageType() {
        return StorageType.BLOB;
    }

    private void assertExisted() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException("Blob or container not existed.");
        }
    }

    private void create() {
        if (!this.blobContainerClient.exists()) {
            LOGGER.debug("Blob container {} doesn't exist, now creating it", (Object)this.blobContainerClient.getBlobContainerName());
            this.blobContainerClient.create();
        }
    }
}

