/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.provider;

import com.azure.core.management.AzureEnvironment;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface AzureProfileOptionsProvider {
    public ProfileOptions getProfile();

    public static interface AzureEnvironmentOptions {
        public String getPortal();

        public String getPublishingProfile();

        public String getManagementEndpoint();

        public String getResourceManagerEndpoint();

        public String getSqlManagementEndpoint();

        public String getSqlServerHostnameSuffix();

        public String getGalleryEndpoint();

        public String getActiveDirectoryEndpoint();

        public String getActiveDirectoryResourceId();

        public String getActiveDirectoryGraphEndpoint();

        public String getMicrosoftGraphEndpoint();

        public String getDataLakeEndpointResourceId();

        public String getActiveDirectoryGraphApiVersion();

        public String getStorageEndpointSuffix();

        public String getKeyVaultDnsSuffix();

        public String getAzureDataLakeStoreFileSystemEndpointSuffix();

        public String getAzureDataLakeAnalyticsCatalogAndJobEndpointSuffix();

        public String getAzureLogAnalyticsEndpoint();

        public String getAzureApplicationInsightsEndpoint();

        public AzureEnvironmentOptions fromAzureManagementEnvironment(AzureEnvironment var1);

        default public AzureEnvironment toAzureManagementEnvironment() {
            HashMap<String, String> endpointsMap = new HashMap<String, String>();
            endpointsMap.put("portalUrl", this.getPortal());
            endpointsMap.put("publishingProfileUrl", this.getPublishingProfile());
            endpointsMap.put("managementEndpointUrl", this.getManagementEndpoint());
            endpointsMap.put("resourceManagerEndpointUrl", this.getResourceManagerEndpoint());
            endpointsMap.put("sqlManagementEndpointUrl", this.getSqlManagementEndpoint());
            endpointsMap.put("sqlServerHostnameSuffix", this.getSqlServerHostnameSuffix());
            endpointsMap.put("galleryEndpointUrl", this.getGalleryEndpoint());
            endpointsMap.put("activeDirectoryEndpointUrl", this.getActiveDirectoryEndpoint());
            endpointsMap.put("activeDirectoryResourceId", this.getActiveDirectoryResourceId());
            endpointsMap.put("activeDirectoryGraphResourceId", this.getActiveDirectoryGraphEndpoint());
            endpointsMap.put("microsoftGraphResourceId", this.getMicrosoftGraphEndpoint());
            endpointsMap.put("dataLakeEndpointResourceId", this.getDataLakeEndpointResourceId());
            endpointsMap.put("activeDirectoryGraphApiVersion", this.getActiveDirectoryGraphApiVersion());
            endpointsMap.put("storageEndpointSuffix", this.getStorageEndpointSuffix());
            endpointsMap.put("keyVaultDnsSuffix", this.getKeyVaultDnsSuffix());
            endpointsMap.put("azureDataLakeStoreFileSystemEndpointSuffix", this.getAzureDataLakeStoreFileSystemEndpointSuffix());
            endpointsMap.put("azureDataLakeAnalyticsCatalogAndJobEndpointSuffix", this.getAzureDataLakeAnalyticsCatalogAndJobEndpointSuffix());
            endpointsMap.put("azureLogAnalyticsResourceId", this.getAzureLogAnalyticsEndpoint());
            endpointsMap.put("azureApplicationInsightsResourceId", this.getAzureApplicationInsightsEndpoint());
            return new AzureEnvironment(endpointsMap);
        }
    }

    public static enum CloudType {
        AZURE,
        AZURE_CHINA,
        AZURE_GERMANY,
        AZURE_US_GOVERNMENT,
        OTHER;

        private static final Map<String, CloudType> CLOUD_TYPE_MAP;

        private static Map<String, CloudType> initMap() {
            return Collections.unmodifiableMap(Arrays.stream(CloudType.values()).collect(Collectors.toMap(c -> c.name(), Function.identity())));
        }

        public static CloudType fromString(String cloudType) {
            return CLOUD_TYPE_MAP.get(cloudType.toUpperCase(Locale.ROOT));
        }

        static {
            CLOUD_TYPE_MAP = CloudType.initMap();
        }
    }

    public static interface ProfileOptions {
        public String getTenantId();

        public String getSubscriptionId();

        public CloudType getCloudType();

        public AzureEnvironmentOptions getEnvironment();
    }
}

