/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.util;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public final class AzureSpringIdentifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureSpringIdentifier.class);
    public static final String VERSION = AzureSpringIdentifier.getVersion();
    public static final String AZURE_SPRING_APP_CONFIG = "az-sp-cfg/" + VERSION;
    public static final String AZURE_SPRING_EVENT_HUBS = "az-sp-eh/" + VERSION;
    public static final String AZURE_SPRING_EVENT_HUBS_KAFKA_OAUTH = "az-sp-kafka";
    public static final String AZURE_SPRING_KEY_VAULT_SECRETS = "az-sp-kv/" + VERSION;
    public static final String AZURE_SPRING_KEY_VAULT_CERTIFICATES = "az-sp-kv-ct/" + VERSION;
    public static final String AZURE_SPRING_SERVICE_BUS = "az-sp-bus/" + VERSION;
    public static final String AZURE_SPRING_STORAGE_BLOB = "az-sp-sb/" + VERSION;
    public static final String AZURE_SPRING_STORAGE_FILES = "az-sp-sf/" + VERSION;
    public static final String AZURE_SPRING_COSMOS = "az-sp-cos/" + VERSION;
    public static final String AZURE_SPRING_STORAGE_QUEUE = "az-sp-sq/" + VERSION;
    public static final String AZURE_SPRING_INTEGRATION_STORAGE_QUEUE = "az-si-sq/" + VERSION;
    public static final String AZURE_SPRING_INTEGRATION_SERVICE_BUS = "az-si-sb/" + VERSION;
    public static final String AZURE_SPRING_INTEGRATION_EVENT_HUBS = "az-si-eh/" + VERSION;
    public static final String AZURE_SPRING_AAD = "az-sp-aad";
    public static final String AZURE_SPRING_B2C = "az-sp-b2c";

    private AzureSpringIdentifier() {
    }

    private static String getVersion() {
        String version = "unknown";
        try {
            Properties properties = PropertiesLoaderUtils.loadProperties((Resource)new ClassPathResource("azure-spring-identifier.properties"));
            version = properties.getProperty("version");
        }
        catch (IOException e) {
            LOGGER.warn("Can not get version.");
        }
        return version;
    }
}

