/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.resource;

import com.azure.spring.cloud.core.resource.StorageType;
import java.util.Locale;
import org.springframework.util.Assert;

final class AzureStorageUtils {
    public static final String PATH_DELIMITER = "/";
    private static final String STORAGE_PROTOCOL_PREFIX = "azure-%s://";

    AzureStorageUtils() {
    }

    static boolean isAzureStorageResource(String location, StorageType storageType) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        return location.toLowerCase(Locale.ROOT).startsWith(AzureStorageUtils.getStorageProtocolPrefix(storageType));
    }

    static String getStorageProtocolPrefix(StorageType storageType) {
        return String.format(STORAGE_PROTOCOL_PREFIX, storageType.getType());
    }

    static String stripProtocol(String location, StorageType storageType) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        AzureStorageUtils.assertIsAzureStorageLocation(location, storageType);
        return location.substring(AzureStorageUtils.getStorageProtocolPrefix(storageType).length());
    }

    static String getContainerName(String location, StorageType storageType) {
        AzureStorageUtils.assertIsAzureStorageLocation(location, storageType);
        int containerEndIndex = AzureStorageUtils.assertContainerValid(location, storageType);
        return location.substring(AzureStorageUtils.getStorageProtocolPrefix(storageType).length(), containerEndIndex);
    }

    static String getFilename(String location, StorageType storageType) {
        AzureStorageUtils.assertIsAzureStorageLocation(location, storageType);
        int containerEndIndex = AzureStorageUtils.assertContainerValid(location, storageType);
        if (location.endsWith(PATH_DELIMITER)) {
            return location.substring(++containerEndIndex, location.length() - 1);
        }
        return location.substring(++containerEndIndex);
    }

    static void assertIsAzureStorageLocation(String location, StorageType storageType) {
        if (!AzureStorageUtils.isAzureStorageResource(location, storageType)) {
            throw new IllegalArgumentException(String.format("The location '%s' is not a valid Azure storage %s location", location, storageType.getType()));
        }
    }

    private static int assertContainerValid(String location, StorageType storageType) {
        String storageProtocolPrefix = AzureStorageUtils.getStorageProtocolPrefix(storageType);
        int containerEndIndex = location.indexOf(PATH_DELIMITER, storageProtocolPrefix.length());
        if (containerEndIndex == -1 || containerEndIndex == storageProtocolPrefix.length()) {
            throw new IllegalArgumentException(String.format("The location '%s' does not contain a valid container name", location));
        }
        return containerEndIndex;
    }
}

