/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.factory.credential;

import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.spring.cloud.core.implementation.factory.credential.AzureAadCredentialBuilderFactory;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.authentication.TokenCredentialOptionsProvider;
import org.springframework.util.StringUtils;

public class ClientCertificateCredentialBuilderFactory
extends AzureAadCredentialBuilderFactory<ClientCertificateCredentialBuilder> {
    public ClientCertificateCredentialBuilderFactory(AzureProperties azureProperties) {
        super(azureProperties);
    }

    @Override
    protected ClientCertificateCredentialBuilder createBuilderInstance() {
        return new ClientCertificateCredentialBuilder();
    }

    @Override
    protected void configureService(ClientCertificateCredentialBuilder builder) {
        super.configureService(builder);
        AzureProperties azureProperties = this.getAzureProperties();
        TokenCredentialOptionsProvider.TokenCredentialOptions credential = azureProperties.getCredential();
        String clientCertificatePath = credential.getClientCertificatePath();
        if (StringUtils.hasText((String)clientCertificatePath)) {
            if (StringUtils.hasText((String)credential.getClientCertificatePassword())) {
                builder.pfxCertificate(clientCertificatePath, credential.getClientCertificatePassword());
            } else {
                builder.pemCertificate(clientCertificatePath);
            }
        }
    }
}

