/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.factory.credential;

import com.azure.identity.AadCredentialBuilderBase;
import com.azure.spring.cloud.core.implementation.factory.credential.AbstractAzureCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.AzureProfileOptionsProvider;
import java.util.concurrent.ExecutorService;

public abstract class AzureAadCredentialBuilderFactory<T extends AadCredentialBuilderBase<T>>
extends AbstractAzureCredentialBuilderFactory<T> {
    private ExecutorService executorService = null;

    public AzureAadCredentialBuilderFactory(AzureProperties azureProperties) {
        super(azureProperties);
    }

    @Override
    protected void configureService(T builder) {
        AzureProperties azureProperties = this.getAzureProperties();
        AzureProfileOptionsProvider.ProfileOptions profile = azureProperties.getProfile();
        PropertyMapper map = new PropertyMapper();
        map.from(azureProperties.getCredential().getClientId()).to(arg_0 -> builder.clientId(arg_0));
        map.from(profile.getTenantId()).to(arg_0 -> builder.tenantId(arg_0));
        map.from(profile.getEnvironment().getActiveDirectoryEndpoint()).to(arg_0 -> builder.authorityHost(arg_0));
        map.from(this.executorService).to(arg_0 -> builder.executorService(arg_0));
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

