/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.resourcemanager;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={AzureResourceManager.class})
@ConditionalOnExpression(value="${spring.cloud.azure.resource-manager.enabled:true}")
@ConditionalOnProperty(value={"spring.cloud.azure.profile.subscription-id"})
public class AzureResourceManagerAutoConfiguration {
    private final AzureGlobalProperties globalProperties;

    AzureResourceManagerAutoConfiguration(AzureGlobalProperties globalProperties) {
        this.globalProperties = globalProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    AzureResourceManager azureResourceManager(ApplicationContext applicationContext, @Qualifier(value="springCloudAzureDefaultCredential") TokenCredential defaultTokenCredential, AzureProfile azureProfile) {
        TokenCredential tokenCredential = defaultTokenCredential;
        String tokenCredentialBeanName = this.globalProperties.getCredential().getTokenCredentialBeanName();
        if (StringUtils.hasText((String)tokenCredentialBeanName)) {
            tokenCredential = (TokenCredential)applicationContext.getBean(tokenCredentialBeanName);
        }
        return AzureResourceManager.configure().authenticate(tokenCredential, azureProfile).withDefaultSubscription();
    }

    @Bean
    @ConditionalOnMissingBean
    AzureProfile azureProfile() {
        return new AzureProfile(this.globalProperties.getProfile().getTenantId(), this.globalProperties.getProfile().getSubscriptionId(), this.globalProperties.getProfile().getEnvironment().toAzureManagementEnvironment());
    }
}

