/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.redis;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.redis.models.RedisCache;
import com.azure.spring.cloud.autoconfigure.implementation.redis.properties.AzureRedisProperties;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.AzureResourceManagerAutoConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.data.redis.autoconfigure.DataRedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.util.ReflectionUtils;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={AzureResourceManagerAutoConfiguration.class})
@ConditionalOnExpression(value="${spring.cloud.azure.redis.enabled:true}")
@ConditionalOnProperty(value={"spring.cloud.azure.redis.name", "spring.cloud.azure.redis.resource.resource-group"})
@ConditionalOnClass(value={RedisOperations.class, AzureResourceManager.class})
@ConditionalOnBean(value={AzureResourceManager.class})
@EnableConfigurationProperties(value={AzureRedisProperties.class})
public class AzureRedisAutoConfiguration {
    @Primary
    @Bean
    DataRedisProperties redisProperties(AzureRedisProperties azureRedisProperties, AzureResourceManager azureResourceManager) throws InvocationTargetException, IllegalAccessException {
        boolean isCluster;
        String cacheName = azureRedisProperties.getName();
        String resourceGroup = azureRedisProperties.getResource().getResourceGroup();
        RedisCache redisCache = (RedisCache)azureResourceManager.redisCaches().getByResourceGroup(resourceGroup, cacheName);
        DataRedisProperties redisProperties = new DataRedisProperties();
        boolean useSsl = !redisCache.nonSslPort();
        int port = useSsl ? redisCache.sslPort() : redisCache.port();
        boolean bl = isCluster = redisCache.shardCount() > 0;
        if (isCluster) {
            DataRedisProperties.Cluster cluster = new DataRedisProperties.Cluster();
            cluster.setNodes(Arrays.asList(redisCache.hostname() + ":" + port));
            redisProperties.setCluster(cluster);
        } else {
            redisProperties.setHost(redisCache.hostname());
            redisProperties.setPort(port);
        }
        redisProperties.setPassword(redisCache.keys().primaryKey());
        Method setSsl = ReflectionUtils.findMethod(DataRedisProperties.class, (String)"setSsl", (Class[])new Class[]{Boolean.TYPE});
        if (setSsl == null) {
            Object ssl = ReflectionUtils.findMethod(DataRedisProperties.class, (String)"getSsl").invoke((Object)redisProperties, new Object[0]);
            Class<?>[] innerClasses = DataRedisProperties.class.getDeclaredClasses();
            Class<?> targetInnerClass = null;
            for (Class<?> innerClass : innerClasses) {
                if (!innerClass.getSimpleName().equals("Ssl")) continue;
                targetInnerClass = innerClass;
                break;
            }
            ReflectionUtils.findMethod(targetInnerClass, (String)"setEnabled", (Class[])new Class[]{Boolean.TYPE}).invoke(ssl, useSsl);
        } else {
            setSsl.invoke((Object)redisProperties, useSsl);
        }
        return redisProperties;
    }
}

