/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.jms;

import com.azure.servicebus.jms.ServiceBusJmsConnectionFactory;
import com.azure.spring.cloud.autoconfigure.implementation.jms.ServiceBusJmsConnectionFactoryFactory;
import com.azure.spring.cloud.autoconfigure.implementation.jms.properties.AzureServiceBusJmsProperties;
import com.azure.spring.cloud.autoconfigure.jms.AzureServiceBusJmsConnectionFactoryCustomizer;
import jakarta.jms.ConnectionFactory;
import java.util.stream.Collectors;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.jms.autoconfigure.JmsPoolConnectionFactoryFactory;
import org.springframework.boot.jms.autoconfigure.JmsProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.util.ClassUtils;

@Import(value={Registrar.class})
class ServiceBusJmsConnectionFactoryConfiguration {
    ServiceBusJmsConnectionFactoryConfiguration() {
    }

    static class Registrar
    implements BeanFactoryAware,
    EnvironmentAware,
    ImportBeanDefinitionRegistrar {
        private Environment environment;
        private BeanFactory beanFactory;
        private static final String JMS_CONNECTION_FACTORY_BEAN_NAME = "jmsConnectionFactory";
        private static final String JMS_POOL_CONNECTION_FACTORY_BEAN_NAME = "jmsPoolConnectionFactory";

        Registrar() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            BindResult poolEnabledResult = Binder.get((Environment)this.environment).bind("spring.jms.servicebus.pool.enabled", Boolean.class);
            BindResult cacheEnabledResult = Binder.get((Environment)this.environment).bind("spring.jms.cache.enabled", Boolean.class);
            if (Registrar.isPoolConnectionFactoryClassPresent() && ((Boolean)poolEnabledResult.orElseGet(() -> false)).booleanValue()) {
                this.registerJmsPoolConnectionFactory(registry);
                return;
            }
            if (Registrar.isCacheConnectionFactoryClassPresent() && ((Boolean)cacheEnabledResult.orElseGet(() -> false)).booleanValue()) {
                this.registerJmsCachingConnectionFactory(registry);
                return;
            }
            this.registerServiceBusJmsConnectionFactory(registry);
        }

        private static boolean isCacheConnectionFactoryClassPresent() {
            return ClassUtils.isPresent((String)"org.springframework.jms.connection.CachingConnectionFactory", null);
        }

        private static boolean isPoolConnectionFactoryClassPresent() {
            return ClassUtils.isPresent((String)"org.messaginghub.pooled.jms.JmsPoolConnectionFactory", null) && ClassUtils.isPresent((String)"org.apache.commons.pool2.PooledObject", null);
        }

        private void registerServiceBusJmsConnectionFactory(BeanDefinitionRegistry registry) {
            BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ServiceBusJmsConnectionFactory.class, this::createServiceBusJmsConnectionFactory);
            registry.registerBeanDefinition(JMS_CONNECTION_FACTORY_BEAN_NAME, (BeanDefinition)definitionBuilder.getBeanDefinition());
        }

        private void registerJmsCachingConnectionFactory(BeanDefinitionRegistry registry) {
            BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(CachingConnectionFactory.class, () -> {
                CachingConnectionFactory connectionFactory = new CachingConnectionFactory((ConnectionFactory)this.createServiceBusJmsConnectionFactory());
                JmsProperties jmsProperties = (JmsProperties)this.beanFactory.getBean(JmsProperties.class);
                JmsProperties.Cache cacheProperties = jmsProperties.getCache();
                connectionFactory.setCacheConsumers(cacheProperties.isConsumers());
                connectionFactory.setCacheProducers(cacheProperties.isProducers());
                connectionFactory.setSessionCacheSize(cacheProperties.getSessionCacheSize());
                return connectionFactory;
            });
            registry.registerBeanDefinition(JMS_CONNECTION_FACTORY_BEAN_NAME, (BeanDefinition)definitionBuilder.getBeanDefinition());
        }

        private void registerJmsPoolConnectionFactory(BeanDefinitionRegistry registry) {
            BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(JmsPoolConnectionFactory.class, () -> {
                AzureServiceBusJmsProperties serviceBusJmsProperties = (AzureServiceBusJmsProperties)this.beanFactory.getBean(AzureServiceBusJmsProperties.class);
                return new JmsPoolConnectionFactoryFactory(serviceBusJmsProperties.getPool()).createPooledConnectionFactory((ConnectionFactory)this.createServiceBusJmsConnectionFactory());
            });
            definitionBuilder.setDestroyMethodName("stop");
            registry.registerBeanDefinition(JMS_POOL_CONNECTION_FACTORY_BEAN_NAME, (BeanDefinition)definitionBuilder.getBeanDefinition());
        }

        private ServiceBusJmsConnectionFactory createServiceBusJmsConnectionFactory() {
            AzureServiceBusJmsProperties serviceBusJmsProperties = (AzureServiceBusJmsProperties)this.beanFactory.getBean(AzureServiceBusJmsProperties.class);
            ObjectProvider factoryCustomizers = this.beanFactory.getBeanProvider(AzureServiceBusJmsConnectionFactoryCustomizer.class);
            return new ServiceBusJmsConnectionFactoryFactory(serviceBusJmsProperties, factoryCustomizers.orderedStream().collect(Collectors.toList())).createConnectionFactory(ServiceBusJmsConnectionFactory.class);
        }
    }
}

