/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.jdbc;

import java.util.Map;
import java.util.TreeMap;
import org.springframework.util.ClassUtils;

public enum DatabaseType {
    MYSQL("jdbc:mysql", "?", "&"),
    POSTGRESQL("jdbc:postgresql", "?", "&"),
    SQLSERVER("jdbc:sqlserver", ";", ";");

    private final String schema;
    private final String pathQueryDelimiter;
    private final String queryDelimiter;

    private DatabaseType(String schema, String pathQueryDelimiter, String queryDelimiter) {
        this.schema = schema;
        this.pathQueryDelimiter = pathQueryDelimiter;
        this.queryDelimiter = queryDelimiter;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getPathQueryDelimiter() {
        return this.pathQueryDelimiter;
    }

    public String getQueryDelimiter() {
        return this.queryDelimiter;
    }

    public boolean isDatabasePluginAvailable() {
        if (POSTGRESQL == this) {
            return this.isPostgresqlPluginAvailable();
        }
        if (MYSQL == this) {
            return this.isMySqlPluginAvailable();
        }
        return false;
    }

    public Map<String, String> getDefaultEnhancedProperties() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (POSTGRESQL == this) {
            result.put("authenticationPluginClassName", "com.azure.identity.extensions.jdbc.postgresql.AzurePostgresqlAuthenticationPlugin");
            result.put("sslmode", "require");
        } else if (MYSQL == this) {
            result.put("sslMode", "REQUIRED");
            result.put("useSSL", "true");
            result.put("defaultAuthenticationPlugin", "com.azure.identity.extensions.jdbc.mysql.AzureMysqlAuthenticationPlugin");
            result.put("authenticationPlugins", "com.azure.identity.extensions.jdbc.mysql.AzureMysqlAuthenticationPlugin");
        }
        return result;
    }

    public void setDefaultEnhancedProperties(Map<String, String> map) {
        map.putAll(this.getDefaultEnhancedProperties());
    }

    private boolean isPostgresqlPluginAvailable() {
        return this.isOnClasspath("com.azure.identity.extensions.jdbc.postgresql.AzurePostgresqlAuthenticationPlugin") && this.isOnClasspath("org.postgresql.plugin.AuthenticationPlugin") && this.isOnClasspath("org.postgresql.Driver");
    }

    private boolean isMySqlPluginAvailable() {
        return this.isOnClasspath("com.azure.identity.extensions.jdbc.mysql.AzureMysqlAuthenticationPlugin") && this.isOnClasspath("com.mysql.cj.protocol.AuthenticationPlugin") && this.isOnClasspath("com.mysql.cj.jdbc.Driver");
    }

    private boolean isOnClasspath(String className) {
        return ClassUtils.isPresent((String)className, null);
    }
}

