/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.security.properties;

import org.springframework.util.StringUtils;

public class AadAuthorizationServerEndpoints {
    private static final String DEFAULT_BASE_URI = "https://login.microsoftonline.com/";
    private static final String AUTHORIZATION_ENDPOINT = "/oauth2/v2.0/authorize";
    private static final String TOKEN_ENDPOINT = "/oauth2/v2.0/token";
    private static final String JWK_SET_ENDPOINT = "/discovery/v2.0/keys";
    private static final String END_SESSION_ENDPOINT = "/oauth2/v2.0/logout";
    private final String baseUri;
    private final String tenantId;

    public AadAuthorizationServerEndpoints(String baseUri, String tenantId) {
        if (!StringUtils.hasText((String)baseUri)) {
            baseUri = DEFAULT_BASE_URI;
        }
        this.baseUri = this.addSlash(baseUri);
        this.tenantId = tenantId;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    private String addSlash(String uri) {
        return uri.endsWith("/") ? uri : uri + "/";
    }

    public String getAuthorizationEndpoint() {
        return this.baseUri + this.tenantId + AUTHORIZATION_ENDPOINT;
    }

    public String getTokenEndpoint() {
        return this.baseUri + this.tenantId + TOKEN_ENDPOINT;
    }

    public String getJwkSetEndpoint() {
        return this.baseUri + this.tenantId + JWK_SET_ENDPOINT;
    }

    public String getEndSessionEndpoint() {
        return this.baseUri + this.tenantId + END_SESSION_ENDPOINT;
    }
}

