/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.security;

import java.util.Optional;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class AadOAuth2AuthorizationCodeGrantRequestParametersConverter
implements Converter<OAuth2AuthorizationCodeGrantRequest, MultiValueMap<String, String>> {
    private final Set<String> azureClientAccessTokenScopes;

    public AadOAuth2AuthorizationCodeGrantRequestParametersConverter(Set<String> azureClientAccessTokenScopes) {
        this.azureClientAccessTokenScopes = azureClientAccessTokenScopes;
    }

    public MultiValueMap<String, String> convert(OAuth2AuthorizationCodeGrantRequest request) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        String scopes = String.join((CharSequence)" ", this.isRequestForAzureClient(request) ? this.azureClientAccessTokenScopes : request.getClientRegistration().getScopes());
        parameters.add((Object)"scope", (Object)scopes);
        return parameters;
    }

    private boolean isRequestForAzureClient(OAuth2AuthorizationCodeGrantRequest request) {
        return Optional.of(request).map(AbstractOAuth2AuthorizationGrantRequest::getClientRegistration).map(ClientRegistration::getRegistrationId).map(id -> id.equals("azure")).orElse(false);
    }
}

