/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.eventhubs;

import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.EventHubConsumerClient;
import com.azure.spring.cloud.autoconfigure.implementation.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.implementation.condition.ConditionalOnMissingProperty;
import com.azure.spring.cloud.autoconfigure.implementation.eventhubs.properties.AzureEventHubsProperties;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import com.azure.spring.cloud.service.implementation.eventhubs.factory.EventHubClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.eventhubs.properties.EventHubClientCommonProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@Import(value={DedicatedConsumerConnectionConfiguration.class, SharedConsumerConnectionConfiguration.class})
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.eventhubs", name={"event-hub-name", "consumer.event-hub-name"})
@ConditionalOnProperty(prefix="spring.cloud.azure.eventhubs.consumer", name={"consumer-group"})
class AzureEventHubsConsumerClientConfiguration {
    AzureEventHubsConsumerClientConfiguration() {
    }

    @ConditionalOnAnyProperty(prefix="spring.cloud.azure.eventhubs.consumer", name={"connection-string", "namespace"})
    @Configuration(proxyBeanMethods=false)
    static class DedicatedConsumerConnectionConfiguration {
        private final AzureEventHubsProperties.Consumer consumerProperties;

        DedicatedConsumerConnectionConfiguration(AzureEventHubsProperties eventHubsProperties) {
            this.consumerProperties = eventHubsProperties.buildConsumerProperties();
        }

        @Bean(value={"springCloudAzureEventHubsConsumerClientBuilderFactory"})
        @ConditionalOnMissingBean(name={"springCloudAzureEventHubsConsumerClientBuilderFactory"})
        EventHubClientBuilderFactory eventHubClientBuilderFactoryForConsumer(ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.EventHubs>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<EventHubClientBuilder>> customizers) {
            EventHubClientBuilderFactory factory = new EventHubClientBuilderFactory((EventHubClientCommonProperties)this.consumerProperties);
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_EVENT_HUBS);
            connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((EventHubClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
            customizers.orderedStream().forEach(arg_0 -> ((EventHubClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
            return factory;
        }

        @Bean(value={"springCloudAzureEventHubsConsumerClientBuilder"})
        @ConditionalOnBean(name={"springCloudAzureEventHubsConsumerClientBuilderFactory"})
        @ConditionalOnMissingBean(name={"springCloudAzureEventHubsConsumerClientBuilder"})
        EventHubClientBuilder eventHubClientBuilderForConsumer(@Qualifier(value="springCloudAzureEventHubsConsumerClientBuilderFactory") EventHubClientBuilderFactory clientBuilderFactory) {
            return (EventHubClientBuilder)clientBuilderFactory.build();
        }

        @Bean
        @ConditionalOnMissingBean
        EventHubConsumerAsyncClient eventHubConsumerAsyncClient(@Qualifier(value="springCloudAzureEventHubsConsumerClientBuilder") EventHubClientBuilder builder) {
            return builder.buildAsyncConsumerClient();
        }

        @Bean
        @ConditionalOnMissingBean
        EventHubConsumerClient eventHubConsumerClient(@Qualifier(value="springCloudAzureEventHubsConsumerClientBuilder") EventHubClientBuilder builder) {
            return builder.buildConsumerClient();
        }
    }

    @ConditionalOnMissingProperty(prefix="spring.cloud.azure.eventhubs.consumer", name={"connection-string", "namespace"})
    @ConditionalOnAnyProperty(prefix="spring.cloud.azure.eventhubs", name={"connection-string", "namespace"})
    @ConditionalOnBean(value={EventHubClientBuilder.class})
    @Configuration(proxyBeanMethods=false)
    static class SharedConsumerConnectionConfiguration {
        private final EventHubClientBuilder builder;

        SharedConsumerConnectionConfiguration(AzureEventHubsProperties properties, EventHubClientBuilder builder) {
            this.builder = builder;
            PropertyMapper mapper = PropertyMapper.get();
            mapper.from((Object)properties.getConsumer().getConsumerGroup()).to(arg_0 -> ((EventHubClientBuilder)builder).consumerGroup(arg_0));
            mapper.from((Object)properties.getConsumer().getPrefetchCount()).to(arg_0 -> ((EventHubClientBuilder)builder).prefetchCount(arg_0));
        }

        @Bean
        @ConditionalOnMissingBean
        EventHubConsumerAsyncClient eventHubConsumerAsyncClient() {
            return this.builder.buildAsyncConsumerClient();
        }

        @Bean
        @ConditionalOnMissingBean
        EventHubConsumerClient eventHubConsumerClient(EventHubClientBuilder builder) {
            return this.builder.buildConsumerClient();
        }
    }
}

