/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aadb2c.security.jwt;

import com.azure.spring.cloud.autoconfigure.implementation.aad.security.jwt.AadTrustedIssuerRepository;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.configuration.properties.AadB2cProperties;
import java.util.Locale;
import java.util.Map;
import org.springframework.util.Assert;

public class AadB2cTrustedIssuerRepository
extends AadTrustedIssuerRepository {
    private final String resolvedBaseUri;
    private final Map<String, String> userFlows;
    private final AadB2cProperties aadB2cProperties;

    public AadB2cTrustedIssuerRepository(AadB2cProperties aadB2cProperties) {
        super(aadB2cProperties.getProfile().getTenantId());
        this.aadB2cProperties = aadB2cProperties;
        this.resolvedBaseUri = this.resolveBaseUri(this.aadB2cProperties.getBaseUri());
        this.userFlows = this.aadB2cProperties.getUserFlows();
        this.addB2cIssuer();
        this.addB2cUserFlowIssuers();
    }

    private void addB2cIssuer() {
        Assert.notNull((Object)this.aadB2cProperties, (String)"aadB2cProperties cannot be null.");
        Assert.notNull((Object)this.resolvedBaseUri, (String)"resolvedBaseUri cannot be null.");
        String issuer = String.format("%s/%s/v2.0/", this.resolvedBaseUri, this.tenantId);
        String oidcIssuerLocation = String.format("%s/%s/%s/v2.0/", this.resolvedBaseUri, this.tenantId, this.userFlows.get(this.aadB2cProperties.getLoginFlow()));
        this.addSpecialOidcIssuerLocationMap(issuer, oidcIssuerLocation);
        this.addTrustedIssuer(issuer);
    }

    private void addB2cUserFlowIssuers() {
        Assert.notNull((Object)this.resolvedBaseUri, (String)"resolvedBaseUri cannot be null.");
        Assert.notNull(this.userFlows, (String)"userFlows cannot be null.");
        AadB2cTrustedIssuerRepository aadB2cTrustedIssuerRepository = this;
        this.userFlows.values().stream().map(uf -> String.format("%s/tfp/%s/%s/v2.0/", this.resolvedBaseUri, this.tenantId, uf.toLowerCase(Locale.ROOT))).forEach(xva$0 -> aadB2cTrustedIssuerRepository.addTrustedIssuer((String)xva$0));
    }
}

