/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.security;

import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadAuthenticationProperties;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;

public class AadOAuth2AuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    private final OAuth2AuthorizationRequestResolver defaultResolver;
    private final AadAuthenticationProperties properties;

    public AadOAuth2AuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository, AadAuthenticationProperties properties) {
        this("/oauth2/authorization", clientRegistrationRepository, properties);
    }

    public AadOAuth2AuthorizationRequestResolver(String authorizationRequestBaseUri, ClientRegistrationRepository clientRegistrationRepository, AadAuthenticationProperties properties) {
        this.defaultResolver = new DefaultOAuth2AuthorizationRequestResolver(clientRegistrationRepository, authorizationRequestBaseUri);
        this.properties = properties;
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
        return this.addClaims(request, this.defaultResolver.resolve(request));
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String clientRegistrationId) {
        return this.addClaims(request, this.defaultResolver.resolve(request, clientRegistrationId));
    }

    private OAuth2AuthorizationRequest addClaims(HttpServletRequest httpServletRequest, OAuth2AuthorizationRequest oAuth2AuthorizationRequest) {
        String conditionalAccessPolicyClaims;
        if (oAuth2AuthorizationRequest == null || httpServletRequest == null) {
            return oAuth2AuthorizationRequest;
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        if (httpSession != null && (conditionalAccessPolicyClaims = (String)httpSession.getAttribute("CONDITIONAL_ACCESS_POLICY_CLAIMS")) != null) {
            httpSession.removeAttribute("CONDITIONAL_ACCESS_POLICY_CLAIMS");
            additionalParameters.put("claims", conditionalAccessPolicyClaims);
        }
        if (this.properties != null && this.properties.getAuthenticateAdditionalParameters() != null) {
            additionalParameters.putAll(this.properties.getAuthenticateAdditionalParameters());
        }
        additionalParameters.putAll(oAuth2AuthorizationRequest.getAdditionalParameters());
        return ((OAuth2AuthorizationRequest.Builder)OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)oAuth2AuthorizationRequest).additionalParameters(additionalParameters)).build();
    }
}

