/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.configuration;

import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.conditions.ClientCertificatePropertiesCondition;
import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.conditions.ClientRegistrationCondition;
import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadAuthenticationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadProfileProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.AadAzureDelegatedOAuth2AuthorizedClientProvider;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.AadClientRegistrationRepository;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.AadJwtBearerGrantRequestParametersConverter;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.AadJwtClientAuthenticationParametersConverter;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.AadOAuth2ClientAuthenticationJwkResolver;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.AadOidcIdTokenDecoderFactory;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.JacksonHttpSessionOAuth2AuthorizedClientRepository;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.OAuth2ClientAuthenticationJwkResolver;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.properties.AadAuthorizationServerEndpoints;
import com.azure.spring.cloud.autoconfigure.implementation.aad.utils.AadRestTemplateCreator;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.JwtBearerOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.RefreshTokenOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.RestClientClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.RestClientJwtBearerTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.RestClientRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ClientRegistrationCondition.class})
class AadOAuth2ClientConfiguration {
    private final RestTemplateBuilder restTemplateBuilder;

    AadOAuth2ClientConfiguration(RestTemplateBuilder restTemplateBuilder) {
        this.restTemplateBuilder = restTemplateBuilder;
    }

    @Bean
    @ConditionalOnMissingBean
    ClientRegistrationRepository clientRegistrationRepository(AadAuthenticationProperties properties) {
        return new AadClientRegistrationRepository(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    OAuth2AuthorizedClientRepository oAuth2AuthorizedClientRepository() {
        return new JacksonHttpSessionOAuth2AuthorizedClientRepository();
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={ClientCertificatePropertiesCondition.class})
    OAuth2ClientAuthenticationJwkResolver oAuth2ClientAuthenticationJwkResolver(AadAuthenticationProperties properties) {
        return new AadOAuth2ClientAuthenticationJwkResolver(properties.getCredential().getClientCertificatePath(), properties.getCredential().getClientCertificatePassword());
    }

    @Bean
    @ConditionalOnMissingBean
    OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clientRegistrations, OAuth2AuthorizedClientRepository authorizedClients, RefreshTokenOAuth2AuthorizedClientProvider refreshTokenProvider, JwtBearerOAuth2AuthorizedClientProvider jwtBearerProvider, ObjectProvider<OAuth2ClientAuthenticationJwkResolver> jwkResolvers) {
        DefaultOAuth2AuthorizedClientManager manager = new DefaultOAuth2AuthorizedClientManager(clientRegistrations, authorizedClients);
        OAuth2ClientAuthenticationJwkResolver jwkResolver = (OAuth2ClientAuthenticationJwkResolver)jwkResolvers.getIfUnique();
        OAuth2AuthorizedClientProvider providers = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().clientCredentials(builder -> this.clientCredentialsGrantBuilderAccessTokenResponseClientCustomizer((OAuth2AuthorizedClientProviderBuilder.ClientCredentialsGrantBuilder)builder, jwkResolver)).provider((OAuth2AuthorizedClientProvider)refreshTokenProvider).provider((OAuth2AuthorizedClientProvider)jwtBearerProvider).provider((OAuth2AuthorizedClientProvider)this.azureDelegatedOAuth2AuthorizedClientProvider(refreshTokenProvider, authorizedClients)).build();
        manager.setAuthorizedClientProvider(providers);
        return manager;
    }

    @Bean
    @ConditionalOnMissingBean
    JwtBearerOAuth2AuthorizedClientProvider azureAdJwtBearerProvider(ObjectProvider<OAuth2ClientAuthenticationJwkResolver> resolvers) {
        JwtBearerOAuth2AuthorizedClientProvider provider = new JwtBearerOAuth2AuthorizedClientProvider();
        OAuth2ClientAuthenticationJwkResolver resolver = (OAuth2ClientAuthenticationJwkResolver)resolvers.getIfUnique();
        RestClientJwtBearerTokenResponseClient client = new RestClientJwtBearerTokenResponseClient();
        client.setRestClient(RestClient.create((RestTemplate)AadRestTemplateCreator.createOAuth2AccessTokenResponseClientRestTemplate(this.restTemplateBuilder)));
        client.addParametersConverter((Converter)new AadJwtBearerGrantRequestParametersConverter());
        if (resolver != null) {
            client.addParametersConverter(new AadJwtClientAuthenticationParametersConverter(resolver::resolve));
        }
        provider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)client);
        return provider;
    }

    @Bean
    @ConditionalOnMissingBean
    RefreshTokenOAuth2AuthorizedClientProvider azureRefreshTokenProvider(ObjectProvider<OAuth2ClientAuthenticationJwkResolver> resolvers) {
        RefreshTokenOAuth2AuthorizedClientProvider provider = new RefreshTokenOAuth2AuthorizedClientProvider();
        OAuth2ClientAuthenticationJwkResolver resolver = (OAuth2ClientAuthenticationJwkResolver)resolvers.getIfUnique();
        RestClientRefreshTokenTokenResponseClient client = new RestClientRefreshTokenTokenResponseClient();
        client.setRestClient(RestClient.create((RestTemplate)AadRestTemplateCreator.createOAuth2AccessTokenResponseClientRestTemplate(this.restTemplateBuilder)));
        if (resolver != null) {
            client.addParametersConverter(new AadJwtClientAuthenticationParametersConverter(resolver::resolve));
        }
        provider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)client);
        return provider;
    }

    @Bean
    @ConditionalOnMissingBean
    JwtDecoderFactory<ClientRegistration> azureAdJwtDecoderFactory(AadAuthenticationProperties properties) {
        AadProfileProperties profile = properties.getProfile();
        AadAuthorizationServerEndpoints endpoints = new AadAuthorizationServerEndpoints(profile.getEnvironment().getActiveDirectoryEndpoint(), profile.getTenantId());
        return new AadOidcIdTokenDecoderFactory(endpoints.getJwkSetEndpoint(), (RestOperations)AadRestTemplateCreator.createRestTemplate(this.restTemplateBuilder));
    }

    private void clientCredentialsGrantBuilderAccessTokenResponseClientCustomizer(OAuth2AuthorizedClientProviderBuilder.ClientCredentialsGrantBuilder builder, OAuth2ClientAuthenticationJwkResolver resolver) {
        RestClientClientCredentialsTokenResponseClient client = new RestClientClientCredentialsTokenResponseClient();
        client.setRestClient(RestClient.create((RestTemplate)AadRestTemplateCreator.createOAuth2AccessTokenResponseClientRestTemplate(this.restTemplateBuilder)));
        if (resolver != null) {
            client.addParametersConverter(new AadJwtClientAuthenticationParametersConverter(resolver::resolve));
        }
        builder.accessTokenResponseClient((OAuth2AccessTokenResponseClient)client);
    }

    private AadAzureDelegatedOAuth2AuthorizedClientProvider azureDelegatedOAuth2AuthorizedClientProvider(RefreshTokenOAuth2AuthorizedClientProvider refreshTokenProvider, OAuth2AuthorizedClientRepository authorizedClients) {
        return new AadAzureDelegatedOAuth2AuthorizedClientProvider(refreshTokenProvider, authorizedClients);
    }
}

