/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.configuration;

import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.AadPropertiesConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadAuthenticationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aad.filter.AadAppRoleStatelessAuthenticationFilter;
import com.azure.spring.cloud.autoconfigure.implementation.aad.filter.AadAuthenticationFilter;
import com.azure.spring.cloud.autoconfigure.implementation.aad.filter.UserPrincipalManager;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.jose.RestOperationsResourceRetriever;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.properties.AadAuthorizationServerEndpoints;
import com.nimbusds.jose.jwk.source.DefaultJWKSetCache;
import com.nimbusds.jose.jwk.source.JWKSetCache;
import com.nimbusds.jose.util.ResourceRetriever;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnExpression(value="${spring.cloud.azure.active-directory.enabled:false}")
@ConditionalOnMissingClass(value={"org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken"})
@Import(value={AadPropertiesConfiguration.class})
public class AadAuthenticationFilterAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AadAuthenticationProperties.class);
    private final AadAuthenticationProperties properties;
    private final AadAuthorizationServerEndpoints endpoints;
    private final RestTemplateBuilder restTemplateBuilder;

    AadAuthenticationFilterAutoConfiguration(AadAuthenticationProperties properties, RestTemplateBuilder restTemplateBuilder) {
        this.properties = properties;
        this.restTemplateBuilder = restTemplateBuilder;
        this.endpoints = new AadAuthorizationServerEndpoints(properties.getProfile().getEnvironment().getActiveDirectoryEndpoint(), properties.getProfile().getTenantId());
    }

    @Bean
    @ConditionalOnMissingBean(value={AadAuthenticationFilter.class})
    @ConditionalOnExpression(value="${spring.cloud.azure.active-directory.session-stateless:false} == false")
    AadAuthenticationFilter aadAuthenticationFilter(ResourceRetriever resourceRetriever, JWKSetCache jwkSetCache) {
        LOGGER.info("AadAuthenticationFilter Constructor.");
        return new AadAuthenticationFilter(this.properties, this.endpoints, resourceRetriever, jwkSetCache, this.restTemplateBuilder);
    }

    @Bean
    @ConditionalOnMissingBean(value={AadAppRoleStatelessAuthenticationFilter.class})
    @ConditionalOnExpression(value="${spring.cloud.azure.active-directory.session-stateless:false} == true")
    AadAppRoleStatelessAuthenticationFilter aadStatelessAuthFilter(ResourceRetriever resourceRetriever) {
        LOGGER.info("Creating AadStatelessAuthFilter bean.");
        return new AadAppRoleStatelessAuthenticationFilter(new UserPrincipalManager(this.endpoints, this.properties, resourceRetriever, true));
    }

    @Bean
    @ConditionalOnMissingBean(value={ResourceRetriever.class})
    ResourceRetriever jwtResourceRetriever() {
        return new RestOperationsResourceRetriever(this.restTemplateBuilder);
    }

    @Bean
    @ConditionalOnMissingBean(value={JWKSetCache.class})
    JWKSetCache jwkSetCache() {
        long lifespan = this.properties.getJwkSetCacheLifespan().toMillis();
        long refreshTime = this.properties.getJwkSetCacheRefreshTime().toMillis();
        return new DefaultJWKSetCache(lifespan, refreshTime, TimeUnit.MILLISECONDS);
    }
}

