/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.resourcemanager;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.spring.cloud.autoconfigure.implementation.condition.ConditionalOnMissingProperty;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.AzureResourceManagerAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.AzureServiceResourceManagerConfigurationBase;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.ServiceBusResourceMetadata;
import com.azure.spring.cloud.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.cloud.resourcemanager.implementation.connectionstring.ServiceBusArmConnectionStringProvider;
import com.azure.spring.cloud.resourcemanager.implementation.provisioning.DefaultServiceBusProvisioner;
import com.azure.spring.cloud.resourcemanager.implementation.provisioning.ServiceBusProvisioner;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@ConditionalOnProperty(prefix="spring.cloud.azure.servicebus", value={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={AzureResourceManager.class})
@AutoConfigureAfter(value={AzureResourceManagerAutoConfiguration.class})
@ConditionalOnClass(value={ServiceBusProvisioner.class})
@EnableConfigurationProperties(value={ServiceBusResourceMetadata.class})
public class AzureServiceBusResourceManagerAutoConfiguration
extends AzureServiceResourceManagerConfigurationBase {
    private final ServiceBusResourceMetadata resourceMetadata;

    AzureServiceBusResourceManagerAutoConfiguration(AzureResourceManager azureResourceManager, ServiceBusResourceMetadata resourceMetadata) {
        super(azureResourceManager);
        this.resourceMetadata = resourceMetadata;
    }

    @Bean
    @ConditionalOnMissingBean
    ServiceBusProvisioner serviceBusProvisioner() {
        return new DefaultServiceBusProvisioner(this.azureResourceManager, (AzureResourceMetadata)this.resourceMetadata);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.azure.servicebus", value={"namespace"})
    @ConditionalOnMissingProperty(prefix="spring.cloud.azure.servicebus", value={"connection-string"})
    @Order
    ServiceBusArmConnectionStringProvider serviceBusArmConnectionStringProvider() {
        return new ServiceBusArmConnectionStringProvider(this.azureResourceManager, (AzureResourceMetadata)this.resourceMetadata, this.resourceMetadata.getName());
    }
}

