/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.utils;

import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public final class AadRestTemplateCreator {
    private AadRestTemplateCreator() {
    }

    public static RestTemplate createRestTemplate(RestTemplateBuilder builder) {
        Assert.notNull((Object)builder, (String)"RestTemplateBuilder cannot be null");
        return builder.build();
    }

    public static RestTemplate createOAuth2ErrorResponseHandledRestTemplate(RestTemplateBuilder builder) {
        builder = builder.errorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        return AadRestTemplateCreator.createRestTemplate(builder);
    }

    public static RestTemplate createOAuth2AccessTokenResponseClientRestTemplate(RestTemplateBuilder builder) {
        builder = builder.messageConverters(new HttpMessageConverter[]{new FormHttpMessageConverter(), new OAuth2AccessTokenResponseHttpMessageConverter()});
        return AadRestTemplateCreator.createOAuth2ErrorResponseHandledRestTemplate(builder);
    }
}

