/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.jdbc;

import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.jdbc.DatabaseType;
import com.azure.spring.cloud.autoconfigure.implementation.jdbc.JdbcConnectionString;
import com.azure.spring.cloud.autoconfigure.implementation.jdbc.JdbcConnectionStringEnhancer;
import com.azure.spring.cloud.autoconfigure.implementation.passwordless.properties.AzureJdbcPasswordlessProperties;
import com.azure.spring.cloud.autoconfigure.implementation.util.SpringPasswordlessPropertiesUtils;
import com.azure.spring.cloud.core.implementation.util.AzurePasswordlessPropertiesUtils;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class JdbcPropertiesBeanPostProcessor
implements BeanPostProcessor,
EnvironmentAware,
ApplicationContextAware,
PriorityOrdered {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcPropertiesBeanPostProcessor.class);
    private GenericApplicationContext applicationContext;
    private Environment environment;

    JdbcPropertiesBeanPostProcessor() {
    }

    public int getOrder() {
        return -2147483645;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSourceProperties) {
            String passwordlessPropertiesPrefix;
            AzureJdbcPasswordlessProperties properties;
            AnnotatedTypeMetadata metadata;
            Map annotationAttributes;
            Object object;
            DataSourceProperties dataSourceProperties = (DataSourceProperties)bean;
            BeanDefinition bd = this.applicationContext.getBeanDefinition(beanName);
            String datasourcePropertiesPrefix = "spring.datasource";
            if (bd != null && (object = bd.getSource()) instanceof AnnotatedTypeMetadata && (annotationAttributes = (metadata = (AnnotatedTypeMetadata)object).getAnnotationAttributes(ConfigurationProperties.class.getName())) != null) {
                datasourcePropertiesPrefix = (String)annotationAttributes.get("prefix");
            }
            if (!(properties = this.buildAzureProperties(passwordlessPropertiesPrefix = datasourcePropertiesPrefix + ".azure")).isPasswordlessEnabled()) {
                LOGGER.debug("Feature passwordless authentication is not enabled(bean name is {} and {}.passwordless-enabled=false), skip enhancing jdbc url.", (Object)beanName, (Object)passwordlessPropertiesPrefix);
                return bean;
            }
            String url = dataSourceProperties.getUrl();
            if (!StringUtils.hasText((String)url)) {
                LOGGER.debug("No '{}.url' provided, skip enhancing jdbc url.", (Object)datasourcePropertiesPrefix);
                return bean;
            }
            JdbcConnectionString connectionString = JdbcConnectionString.resolve(url);
            if (connectionString == null) {
                LOGGER.debug("Can not resolve jdbc connection string from provided {}, skip enhancing jdbc url.", (Object)url);
                return bean;
            }
            boolean isPasswordProvided = StringUtils.hasText((String)dataSourceProperties.getPassword());
            if (isPasswordProvided) {
                LOGGER.debug("If you are using Azure hosted services,it is encouraged to use the passwordless feature ({}). Please refer to https://aka.ms/passwordless-connections.", (Object)datasourcePropertiesPrefix);
                return bean;
            }
            DatabaseType databaseType = connectionString.getDatabaseType();
            if (!databaseType.isDatabasePluginAvailable()) {
                LOGGER.debug("The jdbc plugin with provided jdbc schema is not on the classpath, skip enhancing jdbc url ({}).", (Object)datasourcePropertiesPrefix);
                return bean;
            }
            try {
                JdbcConnectionStringEnhancer enhancer = new JdbcConnectionStringEnhancer(connectionString);
                enhancer.enhanceProperties(this.buildEnhancedProperties(passwordlessPropertiesPrefix, databaseType, properties), true);
                this.enhanceUserAgent(databaseType, enhancer);
                ((DataSourceProperties)bean).setUrl(enhancer.getJdbcUrl());
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Inconsistent properties detected, skip enhancing jdbc url ({}).", (Object)datasourcePropertiesPrefix, (Object)e);
            }
        }
        return bean;
    }

    private void enhanceUserAgent(DatabaseType databaseType, JdbcConnectionStringEnhancer enhancer) {
        if (DatabaseType.MYSQL == databaseType) {
            HashMap<String, String> enhancedAttributes = new HashMap<String, String>();
            enhancedAttributes.put("_extension_version", AzureSpringIdentifier.AZURE_SPRING_MYSQL_OAUTH);
            enhancer.enhancePropertyAttributes("connectionAttributes", enhancedAttributes, ",", ":");
        } else if (DatabaseType.POSTGRESQL == databaseType) {
            HashMap<String, String> enhancedProperties = new HashMap<String, String>();
            enhancedProperties.put("ApplicationName", AzureSpringIdentifier.AZURE_SPRING_POSTGRESQL_OAUTH);
            enhancedProperties.put("assumeMinServerVersion", "9.0.0");
            enhancer.enhanceProperties(enhancedProperties, true);
        }
    }

    private Map<String, String> buildEnhancedProperties(String passwordlessPropertiesPrefix, DatabaseType databaseType, AzureJdbcPasswordlessProperties properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        SpringPasswordlessPropertiesUtils.enhancePasswordlessProperties(passwordlessPropertiesPrefix, (PasswordlessProperties)properties, result);
        databaseType.setDefaultEnhancedProperties(result);
        return result;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (GenericApplicationContext)applicationContext;
    }

    private AzureJdbcPasswordlessProperties buildAzureProperties(String azureDatasourcePrefix) {
        AzureGlobalProperties azureGlobalProperties = (AzureGlobalProperties)this.applicationContext.getBean(AzureGlobalProperties.class);
        AzureJdbcPasswordlessProperties azurePasswordlessProperties = (AzureJdbcPasswordlessProperties)Binder.get((Environment)this.environment).bindOrCreate(azureDatasourcePrefix, AzureJdbcPasswordlessProperties.class);
        AzureJdbcPasswordlessProperties mergedProperties = new AzureJdbcPasswordlessProperties();
        AzurePasswordlessPropertiesUtils.mergeAzureCommonProperties((AzureProperties)azureGlobalProperties, (PasswordlessProperties)azurePasswordlessProperties, (PasswordlessProperties)mergedProperties);
        return mergedProperties;
    }
}

