/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.eventhubs.kafka;

import com.azure.spring.cloud.autoconfigure.implementation.eventhubs.AzureEventHubsAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.eventhubs.kafka.KafkaPropertiesBeanPostProcessor;
import com.azure.spring.cloud.autoconfigure.implementation.resourcemanager.AzureEventHubsResourceManagerAutoConfiguration;
import com.azure.spring.cloud.core.implementation.connectionstring.EventHubsConnectionString;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.provider.connectionstring.StaticConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.kafka.core.KafkaTemplate;

@Deprecated
@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={KafkaTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.azure.eventhubs.kafka.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={AzureEventHubsAutoConfiguration.class, AzureEventHubsResourceManagerAutoConfiguration.class})
public class AzureEventHubsKafkaAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureEventHubsKafkaAutoConfiguration.class);

    @Bean
    @ConditionalOnExpression(value="'${spring.cloud.azure.eventhubs.connection-string:}' != ''")
    @ConditionalOnMissingBean(value={AzureServiceType.EventHubs.class}, parameterizedContainer={ServiceConnectionStringProvider.class})
    StaticConnectionStringProvider<AzureServiceType.EventHubs> eventHubsKafkaConnectionString(Environment environment) {
        String connectionString = environment.getProperty("spring.cloud.azure.eventhubs.connection-string");
        try {
            new EventHubsConnectionString(connectionString);
        }
        catch (Exception e) {
            LOGGER.error("A valid Event Hubs connection string must be provided");
            throw e;
        }
        return new StaticConnectionStringProvider((Object)AzureServiceType.EVENT_HUBS, connectionString);
    }

    @Bean
    @ConditionalOnBean(value={AzureServiceType.EventHubs.class}, parameterizedContainer={ServiceConnectionStringProvider.class})
    static KafkaPropertiesBeanPostProcessor kafkaPropertiesBeanPostProcessor() {
        return new KafkaPropertiesBeanPostProcessor();
    }
}

