/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.compatibility;

import com.azure.spring.cloud.autoconfigure.implementation.compatibility.AzureCompatibilityNotMetException;
import com.azure.spring.cloud.autoconfigure.implementation.compatibility.ClassNameResolverPredicate;
import com.azure.spring.cloud.autoconfigure.implementation.compatibility.VerificationResult;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringBootVersion;
import org.springframework.util.StringUtils;

public class AzureSpringBootVersionVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureSpringBootVersionVerifier.class);
    static final String SPRINGBOOT_CONDITIONAL_CLASS_NAME_OF_3_0 = "org.springframework.boot.autoconfigure.validation.ValidationConfigurationCustomizer";
    static final String SPRINGBOOT_CONDITIONAL_CLASS_NAME_OF_3_1 = "org.springframework.boot.autoconfigure.validation.ValidationConfigurationCustomizer.ValidationConfigurationCustomizer,setIgnoreRegistrationFailure,";
    static final String SPRINGBOOT_CONDITIONAL_CLASS_NAME_OF_3_2 = "org.springframework.boot.autoconfigure.web.client.RestClientSsl";
    static final String SPRINGBOOT_CONDITIONAL_CLASS_NAME_OF_3_3 = "org.springframework.boot.autoconfigure.ldap.PropertiesLdapConnectionDetails";
    private final Map<String, String> supportedVersions = new HashMap<String, String>();
    private final List<String> acceptedVersions;
    private final ClassNameResolverPredicate classNameResolver;

    public AzureSpringBootVersionVerifier(List<String> acceptedVersions, ClassNameResolverPredicate classNameResolver) {
        this.acceptedVersions = acceptedVersions;
        this.classNameResolver = classNameResolver;
        this.initDefaultSupportedBootVersionCheckMeta();
    }

    private void initDefaultSupportedBootVersionCheckMeta() {
        this.supportedVersions.put("3.0", SPRINGBOOT_CONDITIONAL_CLASS_NAME_OF_3_0);
        this.supportedVersions.put("3.1", SPRINGBOOT_CONDITIONAL_CLASS_NAME_OF_3_1);
        this.supportedVersions.put("3.2", SPRINGBOOT_CONDITIONAL_CLASS_NAME_OF_3_2);
        this.supportedVersions.put("3.3", SPRINGBOOT_CONDITIONAL_CLASS_NAME_OF_3_3);
    }

    public VerificationResult verify() {
        if (this.springBootVersionMatches()) {
            return VerificationResult.compatible();
        }
        ArrayList<VerificationResult> errors = new ArrayList<VerificationResult>(Collections.singleton(VerificationResult.notCompatible(this.errorDescription(), this.action())));
        throw new AzureCompatibilityNotMetException(errors);
    }

    private String errorDescription() {
        String versionFromManifest = this.getVersionFromManifest();
        return StringUtils.hasText((String)versionFromManifest) ? String.format("Spring Boot [%s] is not compatible with this Spring Cloud Azure version.", versionFromManifest) : "Spring Boot is not compatible with this Spring Cloud Azure version.";
    }

    private String action() {
        return String.format("Change Spring Boot version to one of the following versions %s.%nYou can find the latest Spring Boot versions here [%s].%nIf you want to learn more about the Spring Cloud Azure compatibility, you can visit this page [%s] and check the [Which Version of Spring Cloud Azure Should I Use] section.%n If you want to disable this check, just set the property [spring.cloud.azure.compatibility-verifier.enabled=false].", this.acceptedVersions, "https://spring.io/projects/spring-boot#learn", "https://aka.ms/spring/versions");
    }

    String getVersionFromManifest() {
        return SpringBootVersion.getVersion();
    }

    private boolean springBootVersionMatches() {
        for (String acceptedVersion : this.acceptedVersions) {
            try {
                if (!this.matchSpringBootVersionFromManifest(acceptedVersion)) continue;
                LOGGER.debug("The current Spring Boot version matches Spring Cloud Azure accepted version [{}].", (Object)acceptedVersion);
                return true;
            }
            catch (FileNotFoundException e) {
                String versionString = AzureSpringBootVersionVerifier.stripWildCardFromVersion(acceptedVersion);
                String fullyQualifiedClassName = this.supportedVersions.get(versionString);
                if (!this.classNameResolver.resolve(fullyQualifiedClassName)) continue;
                LOGGER.debug("Predicate for Spring Boot Version of [{}] was matched.", (Object)versionString);
                return true;
            }
        }
        return false;
    }

    private boolean matchSpringBootVersionFromManifest(String acceptedVersion) throws FileNotFoundException {
        String version = this.getVersionFromManifest();
        LOGGER.debug("Currently running on Spring Boot version [{}], trying to match it with Spring Cloud Azure accepted version [{}].", (Object)version, (Object)acceptedVersion);
        if (!StringUtils.hasText((String)version)) {
            throw new FileNotFoundException("Spring Boot version not found");
        }
        return version.startsWith(AzureSpringBootVersionVerifier.stripWildCardFromVersion(acceptedVersion));
    }

    private static String stripWildCardFromVersion(String version) {
        return version.endsWith(".x") ? version.substring(0, version.indexOf(".x")) : version;
    }
}

