/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.compatibility;

import com.azure.spring.cloud.autoconfigure.implementation.compatibility.AzureSpringBootVersionVerifier;
import com.azure.spring.cloud.autoconfigure.implementation.compatibility.ClassNameResolverPredicate;
import com.azure.spring.cloud.autoconfigure.implementation.compatibility.properties.AzureCompatibilityVerifierProperties;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.azure.compatibility-verifier.enabled"}, matchIfMissing=true)
@AutoConfigureOrder
@EnableConfigurationProperties(value={AzureCompatibilityVerifierProperties.class})
public class AzureCompatibilityVerifierAutoConfiguration {
    @Bean
    AzureSpringBootVersionVerifier springCloudAzureSpringBootVersionVerifier(AzureCompatibilityVerifierProperties properties) {
        AzureSpringBootVersionVerifier verifier = new AzureSpringBootVersionVerifier(properties.getCompatibleBootVersions(), new ClassNameResolverPredicate());
        verifier.verify();
        return verifier;
    }
}

