/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.redis.passwordless.data.jedis;

import com.azure.spring.cloud.autoconfigure.implementation.redis.passwordless.data.jedis.AzureJedisConnection;
import com.azure.spring.cloud.service.implementation.redis.AzureJedisClientConfig;
import com.azure.spring.cloud.service.implementation.redis.AzureJedisPool;
import java.util.function.Supplier;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.util.Pool;

public class AzureJedisConnectionFactory
implements InitializingBean,
DisposableBean,
RedisConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureJedisConnectionFactory.class);
    private final RedisStandaloneConfiguration standaloneConfig;
    private final Supplier<String> credentialSupplier;
    private final JedisClientConfiguration clientConfiguration;
    private JedisClientConfig jedisClientConfig;
    @Nullable
    private Pool<Jedis> pool;
    private boolean initialized;
    private boolean destroyed;
    private boolean convertPipelineAndTxResults = true;

    public AzureJedisConnectionFactory(RedisStandaloneConfiguration standaloneConfig, JedisClientConfiguration clientConfiguration, Supplier<String> credentialSupplier) {
        this.standaloneConfig = standaloneConfig;
        this.clientConfiguration = clientConfiguration;
        this.credentialSupplier = credentialSupplier;
    }

    public void afterPropertiesSet() {
        this.jedisClientConfig = this.createClientConfig(this.standaloneConfig, this.clientConfiguration);
        if (this.getUsePool()) {
            this.pool = this.createRedisPool();
        }
        this.initialized = true;
    }

    public RedisClusterConnection getClusterConnection() {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public boolean getConvertPipelineAndTxResults() {
        return this.convertPipelineAndTxResults;
    }

    public RedisSentinelConnection getSentinelConnection() {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public void destroy() {
        if (this.getUsePool() && this.pool != null) {
            try {
                this.pool.destroy();
            }
            catch (Exception ex) {
                LOGGER.warn("Cannot properly close Jedis pool", (Throwable)ex);
            }
            this.pool = null;
        }
        this.destroyed = true;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public RedisConnection getConnection() {
        this.assertInitialized();
        Jedis jedis = this.fetchJedisConnector();
        JedisClientConfig sentinelConfig = this.jedisClientConfig;
        AzureJedisConnection connection = this.getUsePool() ? new AzureJedisConnection(jedis, this.pool, this.jedisClientConfig, sentinelConfig) : new AzureJedisConnection(jedis, null, this.jedisClientConfig, sentinelConfig);
        connection.setConvertPipelineAndTxResults(this.convertPipelineAndTxResults);
        return this.postProcessConnection(connection);
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    public boolean getUsePool() {
        return this.clientConfiguration.isUsePooling();
    }

    private JedisConnection postProcessConnection(JedisConnection connection) {
        return connection;
    }

    private Pool<Jedis> createRedisPool() {
        return new AzureJedisPool((GenericObjectPoolConfig)this.clientConfiguration.getPoolConfig().get(), new HostAndPort(this.standaloneConfig.getHostName(), this.standaloneConfig.getPort()), this.jedisClientConfig);
    }

    protected Jedis fetchJedisConnector() {
        try {
            if (this.getUsePool() && this.pool != null) {
                LOGGER.info("Get connection from pool.");
                return (Jedis)this.pool.getResource();
            }
            Jedis jedis = this.createJedis();
            jedis.connect();
            return jedis;
        }
        catch (Exception ex) {
            throw new RedisConnectionFailureException("Cannot get Jedis connection", (Throwable)ex);
        }
    }

    private Jedis createJedis() {
        return new Jedis(new HostAndPort(this.standaloneConfig.getHostName(), this.standaloneConfig.getPort()), this.jedisClientConfig);
    }

    private JedisClientConfig createClientConfig(RedisStandaloneConfiguration standaloneConfig, JedisClientConfiguration clientConfig) {
        String username = standaloneConfig.getUsername();
        RedisPassword password = standaloneConfig.getPassword();
        AzureJedisClientConfig.Builder builder = AzureJedisClientConfig.builder();
        clientConfig.getClientName().ifPresent(arg_0 -> ((AzureJedisClientConfig.Builder)builder).clientName(arg_0));
        builder.connectionTimeoutMillis(Math.toIntExact(clientConfig.getConnectTimeout().toMillis()));
        builder.socketTimeoutMillis(Math.toIntExact(clientConfig.getReadTimeout().toMillis()));
        builder.database(standaloneConfig.getDatabase());
        if (!ObjectUtils.isEmpty((Object)username)) {
            builder.user(username);
        }
        password.toOptional().map(String::new).ifPresent(arg_0 -> ((AzureJedisClientConfig.Builder)builder).password(arg_0));
        builder.credentialSupplier(this.credentialSupplier);
        if (clientConfig.isUseSsl()) {
            builder.ssl(true);
            clientConfig.getSslSocketFactory().ifPresent(arg_0 -> ((AzureJedisClientConfig.Builder)builder).sslSocketFactory(arg_0));
            clientConfig.getHostnameVerifier().ifPresent(arg_0 -> ((AzureJedisClientConfig.Builder)builder).hostnameVerifier(arg_0));
            clientConfig.getSslParameters().ifPresent(arg_0 -> ((AzureJedisClientConfig.Builder)builder).sslParameters(arg_0));
        }
        return builder.build();
    }

    private void assertInitialized() {
        Assert.state((boolean)this.initialized, (String)"JedisConnectionFactory was not initialized through afterPropertiesSet()");
        Assert.state((!this.destroyed ? 1 : 0) != 0, (String)"JedisConnectionFactory was destroyed and cannot be used anymore");
    }

    void setPool(@Nullable Pool<Jedis> pool) {
        this.pool = pool;
    }
}

