/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation.oauth2;

import com.azure.spring.cloud.autoconfigure.aad.implementation.oauth2.OAuth2ClientAuthenticationJwkResolver;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.Assert;

public class AadOAuth2ClientAuthenticationJwkResolver
implements OAuth2ClientAuthenticationJwkResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AadOAuth2ClientAuthenticationJwkResolver.class);
    private final String clientCertificatePath;
    private final String clientCertificatePassword;

    public AadOAuth2ClientAuthenticationJwkResolver(String clientCertificatePath, String clientCertificatePassword) {
        Assert.notNull((Object)clientCertificatePath, (String)"clientCertificatePath cannot be null");
        Assert.notNull((Object)clientCertificatePassword, (String)"clientCertificatePassword cannot be null");
        String fileExtension = clientCertificatePath.substring(clientCertificatePath.lastIndexOf(".") + 1);
        Assert.isTrue(("pfx".equals(fileExtension) || "p12".equals(fileExtension) ? 1 : 0) != 0, (String)"Only files with the '.pfx' or '.p12' extension are supported.");
        this.clientCertificatePath = clientCertificatePath;
        this.clientCertificatePassword = clientCertificatePassword;
    }

    @Override
    public JWK resolve(ClientRegistration clientRegistration) {
        if (ClientAuthenticationMethod.PRIVATE_KEY_JWT.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            RSAKey rSAKey;
            FileInputStream inputStream = new FileInputStream(this.clientCertificatePath);
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                char[] password = this.clientCertificatePassword.toCharArray();
                keyStore.load(inputStream, password);
                String alias = keyStore.aliases().nextElement();
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password);
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(alias);
                PublicKey publicKey = x509Certificate.getPublicKey();
                rSAKey = new RSAKey.Builder((RSAPublicKey)publicKey).privateKey(privateKey).x509CertThumbprint(Base64URL.encode((byte[])this.getX5t(x509Certificate))).keyID(UUID.randomUUID().toString()).build();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                    LOGGER.error("Resolve RSAKey exception.", (Throwable)e);
                }
            }
            inputStream.close();
            return rSAKey;
        }
        return null;
    }

    private byte[] getX5t(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        return this.getSHA1Byte(cert.getEncoded());
    }

    private byte[] getSHA1Byte(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.update(data);
        return digest.digest();
    }
}

