/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.kafka;

import com.azure.spring.cloud.autoconfigure.context.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.kafka.AzureKafkaAutoconfigurationUtils;
import com.azure.spring.cloud.service.implementation.kafka.AzureKafkaProperties;
import com.azure.spring.cloud.service.implementation.kafka.AzureKafkaPropertiesUtils;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.provisioning.KafkaTopicProvisioner;

class KafkaBinderConfigurationPropertiesBeanPostProcessor
implements BeanPostProcessor {
    private final AzureGlobalProperties azureGlobalProperties;

    KafkaBinderConfigurationPropertiesBeanPostProcessor(AzureGlobalProperties azureGlobalProperties) {
        this.azureGlobalProperties = azureGlobalProperties;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof KafkaBinderConfigurationProperties) {
            KafkaBinderConfigurationProperties binderConfigurationProperties = (KafkaBinderConfigurationProperties)bean;
            Map mergedConsumerConfiguration = binderConfigurationProperties.mergedConsumerConfiguration();
            Map sourceConsumerProperties = binderConfigurationProperties.getConsumerProperties();
            this.configureKafkaBinderProperties(mergedConsumerConfiguration, sourceConsumerProperties);
            Map mergedProducerConfiguration = binderConfigurationProperties.mergedProducerConfiguration();
            Map sourceProducerProperties = binderConfigurationProperties.getProducerProperties();
            this.configureKafkaBinderProperties(mergedProducerConfiguration, sourceProducerProperties);
            KafkaProperties kafkaProperties = binderConfigurationProperties.getKafkaProperties();
            Map adminProperties = kafkaProperties.buildAdminProperties();
            KafkaTopicProvisioner.normalalizeBootPropsWithBinder((Map)adminProperties, (KafkaProperties)kafkaProperties, (KafkaBinderConfigurationProperties)binderConfigurationProperties);
            this.configureKafkaBinderProperties(adminProperties, binderConfigurationProperties.getConfiguration());
        }
        return bean;
    }

    private void configureKafkaBinderProperties(Map<String, Object> mergedConfiguration, Map<String, String> sourceProperties) {
        if (AzureKafkaAutoconfigurationUtils.needConfigureSaslOAuth(mergedConfiguration)) {
            AzureKafkaProperties azureKafkaProperties = AzureKafkaAutoconfigurationUtils.buildAzureProperties(mergedConfiguration, this.azureGlobalProperties);
            AzureKafkaPropertiesUtils.convertAzurePropertiesToConfigMap((AzureKafkaProperties)azureKafkaProperties, sourceProperties);
            AzureKafkaAutoconfigurationUtils.configureOAuthProperties(sourceProperties);
        }
    }
}

