/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.kafka;

import com.azure.core.credential.TokenCredential;
import com.azure.spring.cloud.autoconfigure.context.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.kafka.AzureKafkaAutoconfigurationUtils;
import com.azure.spring.cloud.core.implementation.credential.resolver.AzureTokenCredentialResolver;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.kafka.AzureKafkaProperties;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.kafka.DefaultKafkaConsumerFactoryCustomizer;
import org.springframework.boot.autoconfigure.kafka.DefaultKafkaProducerFactoryCustomizer;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.ReflectionUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={KafkaTemplate.class})
public class AzureEventHubsKafkaOAuth2AutoConfiguration {
    private final KafkaProperties kafkaProperties;
    private final AzureTokenCredentialResolver tokenCredentialResolver;
    private final AzureGlobalProperties azureGlobalProperties;
    private final TokenCredential defaultTokenCredential;

    AzureEventHubsKafkaOAuth2AutoConfiguration(KafkaProperties kafkaProperties, AzureTokenCredentialResolver resolver, @Qualifier(value="springCloudAzureDefaultCredential") TokenCredential defaultTokenCredential, AzureGlobalProperties azureGlobalProperties) {
        this.kafkaProperties = kafkaProperties;
        this.tokenCredentialResolver = resolver;
        this.defaultTokenCredential = defaultTokenCredential;
        this.azureGlobalProperties = azureGlobalProperties;
        this.configureKafkaUserAgent();
    }

    @Bean
    DefaultKafkaConsumerFactoryCustomizer azureOAuth2KafkaConsumerFactoryCustomizer() {
        HashMap<String, Object> updateConfigs = new HashMap<String, Object>();
        Map consumerProperties = this.kafkaProperties.buildConsumerProperties();
        this.configureOAuth2Properties(updateConfigs, consumerProperties);
        return factory -> factory.updateConfigs(updateConfigs);
    }

    @Bean
    DefaultKafkaProducerFactoryCustomizer azureOAuth2KafkaProducerFactoryCustomizer() {
        HashMap<String, Object> updateConfigs = new HashMap<String, Object>();
        Map producerProperties = this.kafkaProperties.buildProducerProperties();
        this.configureOAuth2Properties(updateConfigs, producerProperties);
        return factory -> factory.updateConfigs(updateConfigs);
    }

    private void configureOAuth2Properties(Map<String, Object> updateConfigs, Map<String, Object> sourceKafkaProperties) {
        if (AzureKafkaAutoconfigurationUtils.needConfigureSaslOAuth(sourceKafkaProperties)) {
            AzureKafkaProperties azureKafkaProperties = AzureKafkaAutoconfigurationUtils.buildAzureProperties(sourceKafkaProperties, this.azureGlobalProperties);
            updateConfigs.put("azure.token.credential", this.resolveSpringCloudAzureTokenCredential(azureKafkaProperties));
            updateConfigs.putAll(AzureKafkaAutoconfigurationUtils.KAFKA_OAUTH_CONFIGS);
            AzureKafkaAutoconfigurationUtils.logConfigureOAuthProperties();
        }
    }

    private TokenCredential resolveSpringCloudAzureTokenCredential(AzureKafkaProperties azureKafkaProperties) {
        TokenCredential tokenCredential = this.tokenCredentialResolver.resolve((AzureProperties)azureKafkaProperties);
        return tokenCredential == null ? this.defaultTokenCredential : tokenCredential;
    }

    private void configureKafkaUserAgent() {
        ApiVersionsRequest apiVersionsRequest;
        ApiVersionsRequestData apiVersionsRequestData;
        Method dataMethod = ReflectionUtils.findMethod(ApiVersionsRequest.class, (String)"data");
        if (dataMethod != null && (apiVersionsRequestData = (ApiVersionsRequestData)ReflectionUtils.invokeMethod((Method)dataMethod, (Object)(apiVersionsRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build()))) != null) {
            apiVersionsRequestData.setClientSoftwareName(apiVersionsRequestData.clientSoftwareName() + "/" + "az-sp-kafka");
            apiVersionsRequestData.setClientSoftwareVersion(AzureSpringIdentifier.VERSION);
        }
    }
}

