/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.kafka;

import com.azure.spring.cloud.autoconfigure.context.AzureGlobalProperties;
import com.azure.spring.cloud.core.implementation.util.AzurePropertiesUtils;
import com.azure.spring.cloud.service.implementation.kafka.AzureKafkaProperties;
import com.azure.spring.cloud.service.implementation.kafka.AzureKafkaPropertiesUtils;
import com.azure.spring.cloud.service.implementation.kafka.KafkaOAuth2AuthenticateCallbackHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AzureKafkaAutoconfigurationUtils {
    public static final Map<String, String> KAFKA_OAUTH_CONFIGS;
    public static final String SECURITY_PROTOCOL_CONFIG_SASL;
    public static final String SASL_MECHANISM_OAUTH = "OAUTHBEARER";
    public static final String SASL_JAAS_CONFIG_OAUTH = "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required;";
    public static final String SASL_LOGIN_CALLBACK_HANDLER_CLASS_OAUTH;
    private static final Logger LOGGER;
    private static final String LOG_OAUTH_AUTOCONFIGURATION_RECOMMENDATION = "Currently {} authentication mechanism is used, recommend to use Spring Cloud Azure auto-configuration for Kafka OAUTHBEARER authentication which supports various Azure Identity credentials. To leverage the auto-configuration for OAuth2, you can just remove all your security, sasl and credential configurations of Kafka and Event Hubs. And configure Kafka bootstrap servers instead, which can be set as spring.kafka.boostrap-servers=EventHubsNamespacesFQDN:9093.";
    private static final String LOG_OAUTH_AUTOCONFIGURATION_CONFIGURE = "Spring Cloud Azure auto-configuration for Kafka OAUTHBEARER authentication will be loaded to configure your Kafka security and sasl properties to support Azure Identity credentials.";
    private static final String LOG_OAUTH_DETAILED_PROPERTY_CONFIGURE = "OAUTHBEARER authentication property {} will be configured as {} to support Azure Identity credentials.";

    private AzureKafkaAutoconfigurationUtils() {
    }

    public static boolean needConfigureSaslOAuth(Map<String, Object> sourceProperties) {
        String securityProtocol = (String)sourceProperties.get("security.protocol");
        String saslMechanism = (String)sourceProperties.get("sasl.mechanism");
        if (securityProtocol == null || SECURITY_PROTOCOL_CONFIG_SASL.equalsIgnoreCase(securityProtocol) && (saslMechanism == null || SASL_MECHANISM_OAUTH.equalsIgnoreCase(saslMechanism))) {
            return true;
        }
        LOGGER.info(LOG_OAUTH_AUTOCONFIGURATION_RECOMMENDATION, (Object)saslMechanism);
        return false;
    }

    public static void configureOAuthProperties(Map<String, String> propertiesToConfigure) {
        propertiesToConfigure.putAll(KAFKA_OAUTH_CONFIGS);
        AzureKafkaAutoconfigurationUtils.logConfigureOAuthProperties();
    }

    public static void logConfigureOAuthProperties() {
        LOGGER.warn(LOG_OAUTH_AUTOCONFIGURATION_CONFIGURE);
        LOGGER.warn(LOG_OAUTH_DETAILED_PROPERTY_CONFIGURE, (Object)"security.protocol", (Object)SECURITY_PROTOCOL_CONFIG_SASL);
        LOGGER.warn(LOG_OAUTH_DETAILED_PROPERTY_CONFIGURE, (Object)"sasl.mechanism", (Object)SASL_MECHANISM_OAUTH);
        LOGGER.warn(LOG_OAUTH_DETAILED_PROPERTY_CONFIGURE, (Object)"sasl.jaas.config", (Object)SASL_JAAS_CONFIG_OAUTH);
        LOGGER.warn(LOG_OAUTH_DETAILED_PROPERTY_CONFIGURE, (Object)"sasl.login.callback.handler.class", (Object)SASL_LOGIN_CALLBACK_HANDLER_CLASS_OAUTH);
    }

    public static AzureKafkaProperties buildAzureProperties(Map<String, Object> kafkaProperties, AzureGlobalProperties azureGlobalProperties) {
        AzureKafkaProperties azureKafkaProperties = new AzureKafkaProperties();
        AzurePropertiesUtils.copyPropertiesIgnoreNull((Object)((Object)azureGlobalProperties.getProfile()), (Object)azureKafkaProperties.getProfile());
        AzurePropertiesUtils.copyPropertiesIgnoreNull((Object)azureGlobalProperties.getCredential(), (Object)azureKafkaProperties.getCredential());
        AzureKafkaPropertiesUtils.convertConfigMapToAzureProperties(kafkaProperties, (AzureKafkaProperties)azureKafkaProperties);
        return azureKafkaProperties;
    }

    static {
        SECURITY_PROTOCOL_CONFIG_SASL = SecurityProtocol.SASL_SSL.name();
        SASL_LOGIN_CALLBACK_HANDLER_CLASS_OAUTH = KafkaOAuth2AuthenticateCallbackHandler.class.getName();
        LOGGER = LoggerFactory.getLogger(AzureKafkaAutoconfigurationUtils.class);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("security.protocol", SECURITY_PROTOCOL_CONFIG_SASL);
        configs.put("sasl.mechanism", SASL_MECHANISM_OAUTH);
        configs.put("sasl.jaas.config", SASL_JAAS_CONFIG_OAUTH);
        configs.put("sasl.login.callback.handler.class", SASL_LOGIN_CALLBACK_HANDLER_CLASS_OAUTH);
        KAFKA_OAUTH_CONFIGS = Collections.unmodifiableMap(configs);
    }
}

