/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.context;

import com.azure.core.amqp.AmqpTransportType;
import com.azure.spring.cloud.autoconfigure.properties.core.authentication.TokenCredentialConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.properties.core.client.ClientConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.properties.core.client.HttpLoggingConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.properties.core.profile.AzureProfileConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.properties.core.proxy.ProxyConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.properties.core.retry.RetryConfigurationProperties;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.properties.client.HeaderProperties;
import com.azure.spring.cloud.core.provider.RetryOptionsProvider;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="spring.cloud.azure")
public class AzureGlobalProperties
implements AzureProperties,
RetryOptionsProvider {
    public static final String PREFIX = "spring.cloud.azure";
    @NestedConfigurationProperty
    private final GlobalClientConfigurationProperties client = new GlobalClientConfigurationProperties();
    @NestedConfigurationProperty
    private final GlobalProxyConfigurationProperties proxy = new GlobalProxyConfigurationProperties();
    @NestedConfigurationProperty
    private final GlobalRetryConfigurationProperties retry = new GlobalRetryConfigurationProperties();
    @NestedConfigurationProperty
    private final TokenCredentialConfigurationProperties credential = new TokenCredentialConfigurationProperties();
    @NestedConfigurationProperty
    private final AzureProfileConfigurationProperties profile = new AzureProfileConfigurationProperties();

    public GlobalClientConfigurationProperties getClient() {
        return this.client;
    }

    public GlobalProxyConfigurationProperties getProxy() {
        return this.proxy;
    }

    public GlobalRetryConfigurationProperties getRetry() {
        return this.retry;
    }

    public TokenCredentialConfigurationProperties getCredential() {
        return this.credential;
    }

    public AzureProfileConfigurationProperties getProfile() {
        return this.profile;
    }

    public static final class GlobalClientConfigurationProperties
    extends ClientConfigurationProperties {
        private final GlobalHttpClientConfigurationProperties http = new GlobalHttpClientConfigurationProperties();
        private final GlobalAmqpClientConfigurationProperties amqp = new GlobalAmqpClientConfigurationProperties();

        public GlobalHttpClientConfigurationProperties getHttp() {
            return this.http;
        }

        public GlobalAmqpClientConfigurationProperties getAmqp() {
            return this.amqp;
        }
    }

    public static final class GlobalProxyConfigurationProperties
    extends ProxyConfigurationProperties {
        private final GlobalHttpProxyConfigurationProperties http = new GlobalHttpProxyConfigurationProperties();
        private final GlobalAmqpProxyConfigurationProperties amqp = new GlobalAmqpProxyConfigurationProperties();

        public GlobalHttpProxyConfigurationProperties getHttp() {
            return this.http;
        }

        public GlobalAmqpProxyConfigurationProperties getAmqp() {
            return this.amqp;
        }
    }

    public static final class GlobalRetryConfigurationProperties
    extends RetryConfigurationProperties {
        private final GlobalAmqpRetryConfigurationProperties amqp = new GlobalAmqpRetryConfigurationProperties();

        public GlobalAmqpRetryConfigurationProperties getAmqp() {
            return this.amqp;
        }
    }

    public static final class GlobalAmqpClientConfigurationProperties {
        private AmqpTransportType transportType = AmqpTransportType.AMQP;

        public AmqpTransportType getTransportType() {
            return this.transportType;
        }

        public void setTransportType(AmqpTransportType transportType) {
            this.transportType = transportType;
        }
    }

    public static final class GlobalHttpClientConfigurationProperties {
        private Duration writeTimeout;
        private Duration responseTimeout;
        private Duration readTimeout;
        private Duration connectTimeout;
        private Integer maximumConnectionPoolSize;
        private Duration connectionIdleTimeout;
        private final List<HeaderProperties> headers = new ArrayList<HeaderProperties>();
        @NestedConfigurationProperty
        private final HttpLoggingConfigurationProperties logging = new HttpLoggingConfigurationProperties();

        public Duration getWriteTimeout() {
            return this.writeTimeout;
        }

        public void setWriteTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
        }

        public Duration getResponseTimeout() {
            return this.responseTimeout;
        }

        public void setResponseTimeout(Duration responseTimeout) {
            this.responseTimeout = responseTimeout;
        }

        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
        }

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public Integer getMaximumConnectionPoolSize() {
            return this.maximumConnectionPoolSize;
        }

        public void setMaximumConnectionPoolSize(Integer maximumConnectionPoolSize) {
            this.maximumConnectionPoolSize = maximumConnectionPoolSize;
        }

        public Duration getConnectionIdleTimeout() {
            return this.connectionIdleTimeout;
        }

        public void setConnectionIdleTimeout(Duration connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
        }

        public List<HeaderProperties> getHeaders() {
            return this.headers;
        }

        public HttpLoggingConfigurationProperties getLogging() {
            return this.logging;
        }
    }

    public static final class GlobalAmqpProxyConfigurationProperties {
        private String authenticationType;

        public String getAuthenticationType() {
            return this.authenticationType;
        }

        public void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }
    }

    public static final class GlobalHttpProxyConfigurationProperties {
        private String nonProxyHosts;

        public String getNonProxyHosts() {
            return this.nonProxyHosts;
        }

        public void setNonProxyHosts(String nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts;
        }
    }

    public static final class GlobalAmqpRetryConfigurationProperties {
        private Duration tryTimeout;

        public Duration getTryTimeout() {
            return this.tryTimeout;
        }

        public void setTryTimeout(Duration tryTimeout) {
            this.tryTimeout = tryTimeout;
        }
    }
}

