/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aadb2c.configuration;

import com.azure.spring.cloud.autoconfigure.aadb2c.configuration.AadB2cPropertiesConfiguration;
import com.azure.spring.cloud.autoconfigure.aadb2c.implementation.AadB2cClientRegistrationRepository;
import com.azure.spring.cloud.autoconfigure.aadb2c.implementation.AadB2cConditions;
import com.azure.spring.cloud.autoconfigure.aadb2c.implementation.AadB2cUrl;
import com.azure.spring.cloud.autoconfigure.aadb2c.properties.AadB2cProperties;
import com.azure.spring.cloud.autoconfigure.aadb2c.properties.AuthorizationClientProperties;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2LoginAuthenticationFilter;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.azure.active-directory.b2c.enabled"}, havingValue="true")
@Conditional(value={AadB2cConditions.ClientRegistrationCondition.class})
@Import(value={AadB2cPropertiesConfiguration.class})
@ConditionalOnClass(value={OAuth2LoginAuthenticationFilter.class})
public class AadB2cOAuth2ClientConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AadB2cOAuth2ClientConfiguration.class);
    private final AadB2cProperties properties;

    public AadB2cOAuth2ClientConfiguration(AadB2cProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientRegistrationRepository clientRegistrationRepository() {
        ArrayList<ClientRegistration> clientRegistrations = new ArrayList<ClientRegistration>();
        clientRegistrations.addAll(this.properties.getUserFlows().entrySet().stream().map(this::buildUserFlowClientRegistration).collect(Collectors.toList()));
        clientRegistrations.addAll(this.properties.getAuthorizationClients().entrySet().stream().map(this::buildClientRegistration).collect(Collectors.toList()));
        return new AadB2cClientRegistrationRepository(this.properties.getLoginFlow(), clientRegistrations);
    }

    private ClientRegistration buildUserFlowClientRegistration(Map.Entry<String, String> client) {
        return ClientRegistration.withRegistrationId((String)client.getValue()).clientName(client.getKey()).clientId(this.properties.getCredential().getClientId()).clientSecret(this.properties.getCredential().getClientSecret()).clientAuthenticationMethod(ClientAuthenticationMethod.POST).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri(this.properties.getReplyUrl()).scope(new String[]{this.properties.getCredential().getClientId(), "openid", "offline_access"}).authorizationUri(AadB2cUrl.getAuthorizationUrl(this.properties.getBaseUri())).tokenUri(AadB2cUrl.getTokenUrl(this.properties.getBaseUri(), client.getValue())).jwkSetUri(AadB2cUrl.getJwkSetUrl(this.properties.getBaseUri(), client.getValue())).userNameAttributeName(this.properties.getUserNameAttributeName()).build();
    }

    private ClientRegistration buildClientRegistration(Map.Entry<String, AuthorizationClientProperties> client) {
        AuthorizationGrantType authGrantType = client.getValue().getAuthorizationGrantType();
        if (!AuthorizationGrantType.CLIENT_CREDENTIALS.equals((Object)authGrantType)) {
            LOGGER.warn("The authorization type of the {} client registration is not supported.", (Object)client.getKey());
        }
        return ClientRegistration.withRegistrationId((String)client.getKey()).clientName(client.getKey()).clientId(this.properties.getCredential().getClientId()).clientSecret(this.properties.getCredential().getClientSecret()).clientAuthenticationMethod(ClientAuthenticationMethod.POST).authorizationGrantType(authGrantType).scope(client.getValue().getScopes()).tokenUri(AadB2cUrl.getAADTokenUrl(this.properties.getProfile().getTenantId())).jwkSetUri(AadB2cUrl.getAADJwkSetUrl(this.properties.getProfile().getTenantId())).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clients, OAuth2AuthorizedClientRepository authorizedClients) {
        return new DefaultOAuth2AuthorizedClientManager(clients, authorizedClients);
    }
}

