/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.configuration;

import com.azure.spring.cloud.autoconfigure.aad.AadClientRegistrationRepository;
import com.azure.spring.cloud.autoconfigure.aad.implementation.conditions.ClientCertificatePropertiesCondition;
import com.azure.spring.cloud.autoconfigure.aad.implementation.conditions.ClientRegistrationCondition;
import com.azure.spring.cloud.autoconfigure.aad.implementation.jwt.AadJwtClientAuthenticationParametersConverter;
import com.azure.spring.cloud.autoconfigure.aad.implementation.oauth2.AadOAuth2ClientAuthenticationJwkResolver;
import com.azure.spring.cloud.autoconfigure.aad.implementation.oauth2.JacksonHttpSessionOAuth2AuthorizedClientRepository;
import com.azure.spring.cloud.autoconfigure.aad.implementation.oauth2.OAuth2ClientAuthenticationJwkResolver;
import com.azure.spring.cloud.autoconfigure.aad.implementation.webapi.AadJwtBearerGrantRequestEntityConverter;
import com.azure.spring.cloud.autoconfigure.aad.implementation.webapp.AadAzureDelegatedOAuth2AuthorizedClientProvider;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadAuthenticationProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.JwtBearerOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.RefreshTokenOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.DefaultClientCredentialsTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.DefaultJwtBearerTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.DefaultPasswordTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.DefaultRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.endpoint.OAuth2PasswordGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequestEntityConverter;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ClientRegistrationCondition.class})
public class AadOAuth2ClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ClientRegistrationRepository clientRegistrationRepository(AadAuthenticationProperties properties) {
        return new AadClientRegistrationRepository(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizedClientRepository oAuth2AuthorizedClientRepository() {
        return new JacksonHttpSessionOAuth2AuthorizedClientRepository();
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={ClientCertificatePropertiesCondition.class})
    OAuth2ClientAuthenticationJwkResolver oAuth2ClientAuthenticationJwkResolver(AadAuthenticationProperties properties) {
        return new AadOAuth2ClientAuthenticationJwkResolver(properties.getCredential().getClientCertificatePath(), properties.getCredential().getClientCertificatePassword());
    }

    @Bean
    @ConditionalOnMissingBean
    OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clientRegistrations, OAuth2AuthorizedClientRepository authorizedClients, RefreshTokenOAuth2AuthorizedClientProvider refreshTokenProvider, JwtBearerOAuth2AuthorizedClientProvider jwtBearerProvider, ObjectProvider<OAuth2ClientAuthenticationJwkResolver> jwkResolvers) {
        DefaultOAuth2AuthorizedClientManager manager = new DefaultOAuth2AuthorizedClientManager(clientRegistrations, authorizedClients);
        OAuth2ClientAuthenticationJwkResolver jwkResolver = (OAuth2ClientAuthenticationJwkResolver)jwkResolvers.getIfUnique();
        OAuth2AuthorizedClientProvider providers = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().clientCredentials(builder -> this.clientCredentialsGrantBuilderAccessTokenResponseClientCustomizer((OAuth2AuthorizedClientProviderBuilder.ClientCredentialsGrantBuilder)builder, jwkResolver)).password(builder -> this.passwordGrantBuilderAccessTokenResponseClientCustomizer((OAuth2AuthorizedClientProviderBuilder.PasswordGrantBuilder)builder, jwkResolver)).provider((OAuth2AuthorizedClientProvider)refreshTokenProvider).provider((OAuth2AuthorizedClientProvider)jwtBearerProvider).provider((OAuth2AuthorizedClientProvider)this.azureDelegatedOAuth2AuthorizedClientProvider(refreshTokenProvider, authorizedClients)).build();
        manager.setAuthorizedClientProvider(providers);
        return manager;
    }

    @Bean
    @ConditionalOnMissingBean
    JwtBearerOAuth2AuthorizedClientProvider azureAdJwtBearerProvider(ObjectProvider<OAuth2ClientAuthenticationJwkResolver> resolvers) {
        JwtBearerOAuth2AuthorizedClientProvider provider = new JwtBearerOAuth2AuthorizedClientProvider();
        OAuth2ClientAuthenticationJwkResolver resolver = (OAuth2ClientAuthenticationJwkResolver)resolvers.getIfUnique();
        if (resolver != null) {
            AadJwtBearerGrantRequestEntityConverter jwtBearerConverter = new AadJwtBearerGrantRequestEntityConverter();
            jwtBearerConverter.addParametersConverter(new AadJwtClientAuthenticationParametersConverter(resolver::resolve));
            DefaultJwtBearerTokenResponseClient responseClient = new DefaultJwtBearerTokenResponseClient();
            responseClient.setRequestEntityConverter((Converter)jwtBearerConverter);
            provider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)responseClient);
        }
        return provider;
    }

    @Bean
    @ConditionalOnMissingBean
    RefreshTokenOAuth2AuthorizedClientProvider azureRefreshTokenProvider(ObjectProvider<OAuth2ClientAuthenticationJwkResolver> resolvers) {
        RefreshTokenOAuth2AuthorizedClientProvider provider = new RefreshTokenOAuth2AuthorizedClientProvider();
        OAuth2ClientAuthenticationJwkResolver resolver = (OAuth2ClientAuthenticationJwkResolver)resolvers.getIfUnique();
        if (resolver != null) {
            OAuth2RefreshTokenGrantRequestEntityConverter converter = new OAuth2RefreshTokenGrantRequestEntityConverter();
            converter.addParametersConverter(new AadJwtClientAuthenticationParametersConverter(resolver::resolve));
            DefaultRefreshTokenTokenResponseClient responseClient = new DefaultRefreshTokenTokenResponseClient();
            responseClient.setRequestEntityConverter((Converter)converter);
            provider.setAccessTokenResponseClient((OAuth2AccessTokenResponseClient)responseClient);
        }
        return provider;
    }

    private void passwordGrantBuilderAccessTokenResponseClientCustomizer(OAuth2AuthorizedClientProviderBuilder.PasswordGrantBuilder builder, OAuth2ClientAuthenticationJwkResolver resolver) {
        if (resolver != null) {
            OAuth2PasswordGrantRequestEntityConverter converter = new OAuth2PasswordGrantRequestEntityConverter();
            converter.addParametersConverter(new AadJwtClientAuthenticationParametersConverter(resolver::resolve));
            DefaultPasswordTokenResponseClient client = new DefaultPasswordTokenResponseClient();
            client.setRequestEntityConverter((Converter)converter);
            builder.accessTokenResponseClient((OAuth2AccessTokenResponseClient)client);
        }
    }

    private void clientCredentialsGrantBuilderAccessTokenResponseClientCustomizer(OAuth2AuthorizedClientProviderBuilder.ClientCredentialsGrantBuilder builder, OAuth2ClientAuthenticationJwkResolver resolver) {
        if (resolver != null) {
            OAuth2ClientCredentialsGrantRequestEntityConverter converter = new OAuth2ClientCredentialsGrantRequestEntityConverter();
            converter.addParametersConverter(new AadJwtClientAuthenticationParametersConverter(resolver::resolve));
            DefaultClientCredentialsTokenResponseClient client = new DefaultClientCredentialsTokenResponseClient();
            client.setRequestEntityConverter((Converter)converter);
            builder.accessTokenResponseClient((OAuth2AccessTokenResponseClient)client);
        }
    }

    private AadAzureDelegatedOAuth2AuthorizedClientProvider azureDelegatedOAuth2AuthorizedClientProvider(RefreshTokenOAuth2AuthorizedClientProvider refreshTokenProvider, OAuth2AuthorizedClientRepository authorizedClients) {
        return new AadAzureDelegatedOAuth2AuthorizedClientProvider(refreshTokenProvider, authorizedClients);
    }
}

