/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.eventhubs;

import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.checkpointstore.blob.BlobCheckpointStore;
import com.azure.spring.cloud.autoconfigure.eventhubs.BlobCheckpointStoreContainerInitializer;
import com.azure.spring.cloud.autoconfigure.implementation.eventhubs.properties.AzureEventHubsProperties;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.service.implementation.storage.blob.BlobServiceClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.storage.blob.BlobServiceClientProperties;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={BlobCheckpointStore.class, EventHubClientBuilder.class})
@ConditionalOnProperty(prefix="spring.cloud.azure.eventhubs.processor.checkpoint-store", name={"container-name", "account-name"})
public class AzureBlobCheckpointStoreConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureBlobCheckpointStoreConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    BlobCheckpointStore blobCheckpointStore(@Qualifier(value="springCloudAzureEventHubsProcessorCheckpointStoreStorageClientBuilder") BlobServiceClientBuilder builder, AzureEventHubsProperties eventHubsProperties, ObjectProvider<BlobCheckpointStoreContainerInitializer> initializers) {
        BlobContainerAsyncClient blobContainerAsyncClient = builder.buildAsyncClient().getBlobContainerAsyncClient(eventHubsProperties.getProcessor().getCheckpointStore().getContainerName());
        initializers.orderedStream().forEach(i -> i.init(blobContainerAsyncClient));
        return new BlobCheckpointStore(blobContainerAsyncClient);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.azure.eventhubs.processor.checkpoint-store.create-container-if-not-exists"}, havingValue="true")
    public BlobCheckpointStoreContainerInitializer blobCheckpointStoreContainerCreationInitializer() {
        return containerAsyncClient -> {
            if (Boolean.FALSE.equals(containerAsyncClient.exists().block(Duration.ofSeconds(3L)))) {
                LOGGER.debug("The checkpoint store container [{}] doesn't exist, will create the blob container now.", (Object)containerAsyncClient.getBlobContainerName());
                containerAsyncClient.create().block(Duration.ofSeconds(3L));
            }
        };
    }

    @Bean(value={"springCloudAzureEventHubsProcessorCheckpointStoreStorageClientBuilder"})
    @ConditionalOnMissingBean(name={"springCloudAzureEventHubsProcessorCheckpointStoreStorageClientBuilder"})
    BlobServiceClientBuilder eventHubProcessorBlobServiceClientBuilder(@Qualifier(value="springCloudAzureEventHubsProcessorCheckpointStoreStorageClientBuilderFactory") BlobServiceClientBuilderFactory factory) {
        return (BlobServiceClientBuilder)factory.build();
    }

    @Bean(value={"springCloudAzureEventHubsProcessorCheckpointStoreStorageClientBuilderFactory"})
    @ConditionalOnMissingBean(name={"springCloudAzureEventHubsProcessorCheckpointStoreStorageClientBuilderFactory"})
    BlobServiceClientBuilderFactory eventHubProcessorBlobServiceClientBuilderFactory(AzureEventHubsProperties eventHubsProperties, ObjectProvider<AzureServiceClientBuilderCustomizer<BlobServiceClientBuilder>> customizers) {
        BlobServiceClientBuilderFactory factory = new BlobServiceClientBuilderFactory((BlobServiceClientProperties)eventHubsProperties.buildProcessorProperties().getCheckpointStore());
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_EVENT_HUBS);
        customizers.orderedStream().forEach(arg_0 -> ((BlobServiceClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }
}

