/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.storage.blob;

import com.azure.spring.cloud.autoconfigure.AzureServiceConfigurationBase;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.context.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.storage.blob.properties.AzureStorageBlobProperties;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.provider.connectionstring.StaticConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import com.azure.spring.cloud.service.implementation.storage.blob.BlobServiceClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.storage.blob.BlobServiceClientProperties;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={BlobServiceClientBuilder.class})
@ConditionalOnProperty(value={"spring.cloud.azure.storage.blob.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.storage.blob", name={"account-name", "endpoint", "connection-string"})
public class AzureStorageBlobAutoConfiguration
extends AzureServiceConfigurationBase {
    AzureStorageBlobAutoConfiguration(AzureGlobalProperties azureGlobalProperties) {
        super(azureGlobalProperties);
    }

    @Bean
    @ConfigurationProperties(value="spring.cloud.azure.storage.blob")
    AzureStorageBlobProperties azureStorageBlobProperties() {
        return this.loadProperties(this.getAzureGlobalProperties(), new AzureStorageBlobProperties());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.azure.storage.blob", name={"blob-name"})
    BlobAsyncClient blobAsyncClient(AzureStorageBlobProperties properties, BlobContainerAsyncClient blobContainerAsyncClient) {
        return blobContainerAsyncClient.getBlobAsyncClient(properties.getBlobName());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.azure.storage.blob", name={"container-name"})
    BlobContainerAsyncClient blobContainerAsyncClient(AzureStorageBlobProperties properties, BlobServiceAsyncClient blobServiceAsyncClient) {
        return blobServiceAsyncClient.getBlobContainerAsyncClient(properties.getContainerName());
    }

    @Bean
    @ConditionalOnMissingBean
    public BlobServiceAsyncClient blobServiceAsyncClient(@Qualifier(value="springCloudAzureStorageBlobClientBuilder") BlobServiceClientBuilder builder) {
        return builder.buildAsyncClient();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.azure.storage.blob", name={"blob-name"})
    BlobClient blobClient(AzureStorageBlobProperties properties, BlobContainerClient blobContainerClient) {
        return blobContainerClient.getBlobClient(properties.getBlobName());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.azure.storage.blob", name={"container-name"})
    BlobContainerClient blobContainerClient(AzureStorageBlobProperties properties, BlobServiceClient blobServiceClient) {
        return blobServiceClient.getBlobContainerClient(properties.getContainerName());
    }

    @Bean
    @ConditionalOnMissingBean
    public BlobServiceClient blobServiceClient(@Qualifier(value="springCloudAzureStorageBlobClientBuilder") BlobServiceClientBuilder builder) {
        return builder.buildClient();
    }

    @Bean(value={"springCloudAzureStorageBlobClientBuilderFactory"})
    @ConditionalOnMissingBean(name={"springCloudAzureStorageBlobClientBuilderFactory"})
    BlobServiceClientBuilderFactory blobServiceClientBuilderFactory(AzureStorageBlobProperties properties, ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.StorageBlob>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<BlobServiceClientBuilder>> customizers) {
        BlobServiceClientBuilderFactory factory = new BlobServiceClientBuilderFactory((BlobServiceClientProperties)properties);
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_STORAGE_BLOB);
        connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((BlobServiceClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
        customizers.orderedStream().forEach(arg_0 -> ((BlobServiceClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean(value={"springCloudAzureStorageBlobClientBuilder"})
    @ConditionalOnMissingBean(name={"springCloudAzureStorageBlobClientBuilder"})
    BlobServiceClientBuilder blobServiceClientBuilder(@Qualifier(value="springCloudAzureStorageBlobClientBuilderFactory") BlobServiceClientBuilderFactory factory) {
        return (BlobServiceClientBuilder)factory.build();
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.azure.storage.blob.connection-string"})
    StaticConnectionStringProvider<AzureServiceType.StorageBlob> staticStorageBlobConnectionStringProvider(AzureStorageBlobProperties properties) {
        return new StaticConnectionStringProvider((Object)AzureServiceType.STORAGE_BLOB, properties.getConnectionString());
    }
}

