/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.jms;

import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnMissingProperty;
import com.azure.spring.cloud.autoconfigure.jms.AzureServiceBusJmsPropertiesBeanPostProcessor;
import com.azure.spring.cloud.autoconfigure.jms.ServiceBusJmsConnectionFactoryConfiguration;
import com.azure.spring.cloud.autoconfigure.jms.ServiceBusJmsConnectionFactoryCustomizer;
import com.azure.spring.cloud.autoconfigure.jms.ServiceBusJmsContainerConfiguration;
import com.azure.spring.cloud.autoconfigure.jms.properties.AzureServiceBusJmsProperties;
import com.azure.spring.cloud.autoconfigure.resourcemanager.AzureServiceBusResourceManagerAutoConfiguration;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import java.util.HashMap;
import javax.jms.ConnectionFactory;
import org.apache.qpid.jms.JmsConnectionExtensions;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.autoconfigure.jms.JndiConnectionFactoryAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jms.core.JmsTemplate;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@AutoConfigureAfter(value={JndiConnectionFactoryAutoConfiguration.class, AzureServiceBusResourceManagerAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, JmsConnectionFactory.class, JmsTemplate.class})
@EnableConfigurationProperties(value={AzureServiceBusJmsProperties.class, JmsProperties.class})
@Import(value={ServiceBusJmsConnectionFactoryConfiguration.class, ServiceBusJmsContainerConfiguration.class})
public class ServiceBusJmsAutoConfiguration {
    @Bean
    @ConditionalOnExpression(value="'premium'.equalsIgnoreCase('${spring.jms.servicebus.pricing-tier}')")
    ServiceBusJmsConnectionFactoryCustomizer amqpOpenPropertiesCustomizer() {
        return factory -> {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("com.microsoft:is-client-provider", true);
            properties.put("user-agent", AzureSpringIdentifier.AZURE_SPRING_SERVICE_BUS);
            factory.setExtension(JmsConnectionExtensions.AMQP_OPEN_PROPERTIES.toString(), (connection, uri) -> properties);
        };
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingProperty(prefix="spring.jms.servicebus", name={"connection-string"})
    public static AzureServiceBusJmsPropertiesBeanPostProcessor azureServiceBusJmsPropertiesBeanPostProcessor(ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders) {
        return new AzureServiceBusJmsPropertiesBeanPostProcessor(connectionStringProviders);
    }
}

