/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.cloudfoundry.environment;

import com.azure.spring.cloud.autoconfigure.cloudfoundry.environment.VcapPojo;
import com.azure.spring.cloud.autoconfigure.cloudfoundry.environment.VcapResult;
import com.azure.spring.cloud.autoconfigure.cloudfoundry.environment.VcapServiceConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.json.JsonParseException;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@Configuration
public class VcapProcessor
implements EnvironmentPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(VcapProcessor.class);
    private static final String VCAP_SERVICES = "VCAP_SERVICES";
    private static final String LOG_VARIABLE = "COM_MICROSOFT_AZURE_CLOUDFOUNDRY_SERVICE_LOG";
    private static final String AZURE = "azure-";
    private static final String USER_PROVIDED = "user-provided";
    private static final String AZURE_SERVICE_BROKER_NAME = "azure-service-broker-name";
    private static final String AZURE_SERVICE_PLAN = "azure-service-plan";
    private static final String CREDENTIALS = "credentials";
    private boolean logFlag = false;

    public void postProcessEnvironment(ConfigurableEnvironment confEnv, SpringApplication app) {
        Map environment = confEnv.getSystemEnvironment();
        String logValue = (String)environment.get(LOG_VARIABLE);
        if ("true".equals(logValue)) {
            this.logFlag = true;
        }
        this.log("VcapParser.postProcessEnvironment: Start");
        String vcapServices = (String)environment.get(VCAP_SERVICES);
        List<VcapPojo> vcapPojos = this.parseVcapService(vcapServices);
        new VcapResult(confEnv, vcapPojos.toArray(new VcapPojo[0]), this.logFlag);
        this.log("VcapParser.postProcessEnvironment: End");
    }

    private VcapServiceConfig getVcapServiceConfig(@NonNull Map<String, Object> configMap) {
        VcapServiceConfig serviceConfig = new VcapServiceConfig();
        serviceConfig.setLabel(configMap.getOrDefault("label", null));
        serviceConfig.setName(configMap.getOrDefault("name", null));
        serviceConfig.setProvider(configMap.getOrDefault("provider", null));
        serviceConfig.setSyslogDrainUrl(configMap.getOrDefault("syslog_drain_url", null));
        serviceConfig.setPlan(configMap.getOrDefault("plan", null));
        List tags = (List)configMap.get("tags");
        List volumeMounts = (List)configMap.get("volume_mounts");
        if (tags != null) {
            serviceConfig.setTags(tags.toArray(new String[0]));
        }
        if (volumeMounts != null) {
            serviceConfig.setVolumeMounts(volumeMounts.toArray(new String[0]));
        }
        serviceConfig.setCredentials((Map)configMap.get(CREDENTIALS));
        return serviceConfig;
    }

    private List<VcapServiceConfig> getVcapServiceConfigList(@NonNull Object value) {
        Assert.isInstanceOf(List.class, (Object)value);
        List configs = (List)value;
        return configs.stream().map(this::getVcapServiceConfig).collect(Collectors.toList());
    }

    List<VcapPojo> parseVcapService(String vcapServices) {
        ArrayList<VcapPojo> results = new ArrayList<VcapPojo>();
        this.log("VcapParser.parse:  vcapServices = " + vcapServices);
        if (StringUtils.hasText((String)vcapServices)) {
            try {
                JsonParser parser = JsonParserFactory.getJsonParser();
                Map servicesMap = parser.parseMap(vcapServices);
                Set services = servicesMap.entrySet();
                Assert.notNull(services, (String)"Services entrySet cannot be null.");
                for (Map.Entry serviceEntry : services) {
                    String name = (String)serviceEntry.getKey();
                    if (!name.startsWith(AZURE) && !USER_PROVIDED.equals(name)) continue;
                    Assert.isInstanceOf(List.class, serviceEntry.getValue());
                    List<VcapServiceConfig> azureServices = this.getVcapServiceConfigList(serviceEntry.getValue());
                    results.addAll(azureServices.stream().map(service -> this.parseService(name, (VcapServiceConfig)service, vcapServices)).filter(Objects::nonNull).collect(Collectors.toList()));
                }
            }
            catch (JsonParseException e) {
                LOGGER.error("Error parsing " + vcapServices, (Throwable)e);
            }
        }
        return results;
    }

    private VcapPojo parseService(String serviceBrokerName, VcapServiceConfig serviceConfig, String vCapServices) {
        VcapPojo result = new VcapPojo();
        Map<String, String> credentials = serviceConfig.getCredentials();
        if (USER_PROVIDED.equals(serviceBrokerName)) {
            if (credentials == null) {
                return null;
            }
            String userServiceBrokerName = credentials.remove(AZURE_SERVICE_BROKER_NAME);
            if (userServiceBrokerName == null) {
                return null;
            }
            result.setServiceBrokerName(userServiceBrokerName);
            String userServicePlan = credentials.remove(AZURE_SERVICE_PLAN);
            serviceConfig.setPlan(userServicePlan);
            serviceConfig.setCredentials(credentials);
        } else {
            result.setServiceBrokerName(serviceBrokerName);
            serviceConfig.setPlan(serviceConfig.getPlan());
            if (credentials == null) {
                LOGGER.error("Found " + serviceBrokerName + ", but missing " + CREDENTIALS + " : " + vCapServices);
            }
        }
        result.setServiceConfig(serviceConfig);
        return result;
    }

    private void log(String msg) {
        if (this.logFlag) {
            LOGGER.info(msg);
        }
    }
}

