/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aadb2c;

import com.azure.spring.cloud.autoconfigure.aadb2c.implementation.AadB2cUrl;
import com.azure.spring.cloud.autoconfigure.aadb2c.properties.AadB2cProperties;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

public class AadB2cLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    private final AadB2cProperties properties;

    public AadB2cLogoutSuccessHandler(AadB2cProperties properties) {
        this.properties = properties;
        super.setDefaultTargetUrl(this.getAadB2cEndSessionUrl());
    }

    private String getAadB2cEndSessionUrl() {
        String userFlow = this.properties.getUserFlows().get(this.properties.getLoginFlow());
        String logoutSuccessUrl = this.properties.getLogoutSuccessUrl();
        return AadB2cUrl.getEndSessionUrl(this.properties.getBaseUri(), logoutSuccessUrl, userFlow);
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        super.onLogoutSuccess(request, response, authentication);
    }
}

