/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.properties;

import com.azure.spring.cloud.autoconfigure.aad.properties.AadApplicationType;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadAuthorizationGrantType;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadCredentialProperties;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadProfileProperties;
import com.azure.spring.cloud.autoconfigure.aad.properties.AuthorizationClientProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.StringUtils;

public class AadAuthenticationProperties
implements InitializingBean {
    public static final String PREFIX = "spring.cloud.azure.active-directory";
    private static final Logger LOGGER = LoggerFactory.getLogger(AadAuthenticationProperties.class);
    @NestedConfigurationProperty
    private final AadProfileProperties profile = new AadProfileProperties();
    @NestedConfigurationProperty
    private final AadCredentialProperties credential = new AadCredentialProperties();
    private final UserGroupProperties userGroup = new UserGroupProperties();
    private String userNameAttribute;
    private String redirectUriTemplate = "{baseUrl}/login/oauth2/code/";
    private String appIdUri;
    private final Map<String, Object> authenticateAdditionalParameters = new HashMap<String, Object>();
    private Duration jwtConnectTimeout = Duration.ofMillis(500L);
    private Duration jwtReadTimeout = Duration.ofMillis(500L);
    private int jwtSizeLimit = 51200;
    private Duration jwkSetCacheLifespan = Duration.ofMinutes(5L);
    private Duration jwkSetCacheRefreshTime = Duration.ofMinutes(5L);
    private String postLogoutRedirectUri;
    private Boolean sessionStateless = false;
    private final Map<String, AuthorizationClientProperties> authorizationClients = new HashMap<String, AuthorizationClientProperties>();
    private AadApplicationType applicationType;

    public AadProfileProperties getProfile() {
        return this.profile;
    }

    public AadCredentialProperties getCredential() {
        return this.credential;
    }

    public AadApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(AadApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public boolean isAllowedGroupNamesConfigured() {
        return Optional.of(this.getUserGroup()).map(UserGroupProperties::getAllowedGroupNames).map(allowedGroupNames -> !allowedGroupNames.isEmpty()).orElse(false);
    }

    public boolean isAllowedGroupIdsConfigured() {
        return Optional.of(this.getUserGroup()).map(UserGroupProperties::getAllowedGroupIds).map(allowedGroupIds -> !allowedGroupIds.isEmpty()).orElse(false);
    }

    public UserGroupProperties getUserGroup() {
        return this.userGroup;
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    public String getRedirectUriTemplate() {
        return this.redirectUriTemplate;
    }

    public void setRedirectUriTemplate(String redirectUriTemplate) {
        this.redirectUriTemplate = redirectUriTemplate;
    }

    public String getAppIdUri() {
        return this.appIdUri;
    }

    public void setAppIdUri(String appIdUri) {
        this.appIdUri = appIdUri;
    }

    public Map<String, Object> getAuthenticateAdditionalParameters() {
        return this.authenticateAdditionalParameters;
    }

    public Duration getJwtConnectTimeout() {
        return this.jwtConnectTimeout;
    }

    public void setJwtConnectTimeout(Duration jwtConnectTimeout) {
        this.jwtConnectTimeout = jwtConnectTimeout;
    }

    public Duration getJwtReadTimeout() {
        return this.jwtReadTimeout;
    }

    public void setJwtReadTimeout(Duration jwtReadTimeout) {
        this.jwtReadTimeout = jwtReadTimeout;
    }

    public int getJwtSizeLimit() {
        return this.jwtSizeLimit;
    }

    public void setJwtSizeLimit(int jwtSizeLimit) {
        this.jwtSizeLimit = jwtSizeLimit;
    }

    public Duration getJwkSetCacheLifespan() {
        return this.jwkSetCacheLifespan;
    }

    public void setJwkSetCacheLifespan(Duration jwkSetCacheLifespan) {
        this.jwkSetCacheLifespan = jwkSetCacheLifespan;
    }

    public Duration getJwkSetCacheRefreshTime() {
        return this.jwkSetCacheRefreshTime;
    }

    public void setJwkSetCacheRefreshTime(Duration jwkSetCacheRefreshTime) {
        this.jwkSetCacheRefreshTime = jwkSetCacheRefreshTime;
    }

    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public Boolean getSessionStateless() {
        return this.sessionStateless;
    }

    public void setSessionStateless(Boolean sessionStateless) {
        this.sessionStateless = sessionStateless;
    }

    public String getGraphMembershipUri() {
        return this.getProfile().getEnvironment().getMicrosoftGraphEndpoint() + (this.getUserGroup().isUseTransitiveMembers() ? "v1.0/me/transitiveMemberOf" : "v1.0/me/memberOf");
    }

    public Map<String, AuthorizationClientProperties> getAuthorizationClients() {
        return this.authorizationClients;
    }

    public boolean isAllowedGroup(String group) {
        return Optional.ofNullable(this.getUserGroup()).map(UserGroupProperties::getAllowedGroupNames).orElseGet(Collections::emptyList).contains(group) || Optional.ofNullable(this.getUserGroup()).map(UserGroupProperties::getAllowedGroupIds).orElseGet(Collections::emptySet).contains(group);
    }

    public void afterPropertiesSet() {
        if (!StringUtils.hasText((String)this.getProfile().getTenantId())) {
            this.getProfile().setTenantId("common");
        }
        this.validateProperties();
    }

    private void validateProperties() {
        Set<String> allowedGroupIds = this.userGroup.getAllowedGroupIds();
        if (allowedGroupIds.size() > 1 && allowedGroupIds.contains("all")) {
            throw new IllegalStateException("When spring.cloud.azure.active-directory.user-group.allowed-group-ids contains 'all', no other group ids can be configured. But actually spring.cloud.azure.active-directory.user-group.allowed-group-ids=" + allowedGroupIds);
        }
        this.validateTenantId();
        this.validateApplicationType();
        this.validateAuthorizationClients();
    }

    private void validateAuthorizationClients() {
        this.authorizationClients.forEach(this::validateAuthorizationClientProperties);
    }

    private void validateTenantId() {
        if (this.isMultiTenantsApplication(this.getProfile().getTenantId()) && !this.userGroup.getAllowedGroupNames().isEmpty()) {
            throw new IllegalStateException("When spring.cloud.azure.active-directory.profile.tenant-id is 'common/organizations/consumers', spring.cloud.azure.active-directory.user-group.allowed-group-names should be empty. But actually spring.cloud.azure.active-directory.profile.tenant-id=" + this.getProfile().getTenantId() + ", and spring.cloud.azure.active-directory.user-group.allowed-group-names=" + this.userGroup.getAllowedGroupNames());
        }
        if (this.isMultiTenantsApplication(this.getProfile().getTenantId()) && !this.userGroup.getAllowedGroupIds().isEmpty()) {
            throw new IllegalStateException("When spring.cloud.azure.active-directory.profile.tenant-id is 'common/organizations/consumers', spring.cloud.azure.active-directory.user-group.allowed-group-ids should be empty. But actually spring.cloud.azure.active-directory.profile.tenant-id=" + this.getProfile().getTenantId() + ", and spring.cloud.azure.active-directory.user-group.allowed-group-ids=" + this.userGroup.getAllowedGroupIds());
        }
    }

    private void validateApplicationType() {
        AadApplicationType inferred = AadApplicationType.inferApplicationTypeByDependencies();
        if (this.applicationType != null) {
            if (!this.isValidApplicationType(this.applicationType, inferred)) {
                throw new IllegalStateException("Invalid property 'spring.cloud.azure.active-directory.application-type', the configured value is '" + this.applicationType.getValue() + "', but the inferred value is '" + inferred.getValue() + "'.");
            }
        } else {
            this.applicationType = inferred;
        }
    }

    private boolean isValidApplicationType(AadApplicationType configured, AadApplicationType inferred) {
        return inferred == configured || inferred == AadApplicationType.RESOURCE_SERVER_WITH_OBO;
    }

    private void validateAuthorizationClientProperties(String registrationId, AuthorizationClientProperties properties) {
        block20: {
            String grantType;
            block19: {
                grantType = Optional.of(properties).map(AuthorizationClientProperties::getAuthorizationGrantType).map(AadAuthorizationGrantType::getValue).orElse(null);
                if (null != grantType) break block19;
                switch (this.applicationType) {
                    case WEB_APPLICATION: {
                        if (registrationId.equals("azure")) {
                            properties.setAuthorizationGrantType(AadAuthorizationGrantType.AUTHORIZATION_CODE);
                        } else {
                            properties.setAuthorizationGrantType(AadAuthorizationGrantType.AZURE_DELEGATED);
                        }
                        LOGGER.debug("The client '{}' sets the default value of AADAuthorizationGrantType to 'authorization_code'.", (Object)registrationId);
                        break block20;
                    }
                    case RESOURCE_SERVER: 
                    case RESOURCE_SERVER_WITH_OBO: {
                        properties.setAuthorizationGrantType(AadAuthorizationGrantType.ON_BEHALF_OF);
                        LOGGER.debug("The client '{}' sets the default value of AADAuthorizationGrantType to 'on_behalf_of'.", (Object)registrationId);
                        break block20;
                    }
                    case WEB_APPLICATION_AND_RESOURCE_SERVER: {
                        throw new IllegalStateException("spring.cloud.azure.active-directory.authorization-clients." + registrationId + ".authorization-grant-grantType must be configured. ");
                    }
                    default: {
                        throw new IllegalStateException("Unsupported authorization grantType " + this.applicationType.getValue());
                    }
                }
            }
            switch (this.applicationType) {
                case WEB_APPLICATION: {
                    if (!AadAuthorizationGrantType.ON_BEHALF_OF.getValue().equals(grantType)) break;
                    throw new IllegalStateException("When 'spring.cloud.azure.active-directory.application-type=web_application', 'spring.cloud.azure.active-directory.authorization-clients." + registrationId + ".authorization-grant-type' can not be 'on_behalf_of'.");
                }
                case RESOURCE_SERVER: {
                    if (AadAuthorizationGrantType.AUTHORIZATION_CODE.getValue().equals(grantType)) {
                        throw new IllegalStateException("When 'spring.cloud.azure.active-directory.application-type=resource_server', 'spring.cloud.azure.active-directory.authorization-clients." + registrationId + ".authorization-grant-type' can not be 'authorization_code'.");
                    }
                    if (!AadAuthorizationGrantType.ON_BEHALF_OF.getValue().equals(grantType)) break;
                    throw new IllegalStateException("When 'spring.cloud.azure.active-directory.application-type=resource_server', 'spring.cloud.azure.active-directory.authorization-clients." + registrationId + ".authorization-grant-type' can not be 'on_behalf_of'.");
                }
                case RESOURCE_SERVER_WITH_OBO: {
                    if (!AadAuthorizationGrantType.AUTHORIZATION_CODE.getValue().equals(grantType)) break;
                    throw new IllegalStateException("When 'spring.cloud.azure.active-directory.application-type=resource_server_with_obo', 'spring.cloud.azure.active-directory.authorization-clients." + registrationId + ".authorization-grant-type' can not be 'authorization_code'.");
                }
                default: {
                    LOGGER.debug("'spring.cloud.azure.active-directory.authorization-clients." + registrationId + ".authorization-grant-type' is valid.");
                }
            }
            if ("azure".equals(registrationId) && !AadAuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)properties.getAuthorizationGrantType())) {
                throw new IllegalStateException("spring.cloud.azure.active-directory.authorization-clients.azure.authorization-grant-type must be configured to 'authorization_code'.");
            }
        }
        List<String> scopes = properties.getScopes();
        if (scopes == null || scopes.isEmpty()) {
            throw new IllegalStateException("'spring.cloud.azure.active-directory.authorization-clients." + registrationId + ".scopes' must be configured");
        }
        if (properties.getAuthorizationGrantType().getValue().equals(AadAuthorizationGrantType.AUTHORIZATION_CODE.getValue())) {
            if (!scopes.contains("openid")) {
                scopes.add("openid");
            }
            if (!scopes.contains("profile")) {
                scopes.add("profile");
            }
            if (!scopes.contains("offline_access")) {
                scopes.add("offline_access");
            }
        }
    }

    private boolean isMultiTenantsApplication(String tenantId) {
        return "common".equals(tenantId) || "organizations".equals(tenantId) || "consumers".equals(tenantId);
    }

    public static class UserGroupProperties {
        private List<String> allowedGroupNames = new ArrayList<String>();
        private Set<String> allowedGroupIds = new HashSet<String>();
        private boolean useTransitiveMembers = false;

        public Set<String> getAllowedGroupIds() {
            return this.allowedGroupIds;
        }

        public void setAllowedGroupIds(Set<String> allowedGroupIds) {
            this.allowedGroupIds = allowedGroupIds;
        }

        public List<String> getAllowedGroupNames() {
            return this.allowedGroupNames;
        }

        public void setAllowedGroupNames(List<String> allowedGroupNames) {
            this.allowedGroupNames = allowedGroupNames;
        }

        public boolean isUseTransitiveMembers() {
            return this.useTransitiveMembers;
        }

        public void setUseTransitiveMembers(boolean useTransitiveMembers) {
            this.useTransitiveMembers = useTransitiveMembers;
        }
    }
}

