/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation.webapi.validator;

import com.azure.spring.cloud.autoconfigure.aad.AadTrustedIssuerRepository;
import java.util.function.Predicate;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.util.Assert;

public class AadJwtIssuerValidator
implements OAuth2TokenValidator<Jwt> {
    private static final String LOGIN_MICROSOFT_ONLINE_ISSUER = "https://login.microsoftonline.com/";
    private static final String STS_WINDOWS_ISSUER = "https://sts.windows.net/";
    private static final String STS_CHINA_CLOUD_API_ISSUER = "https://sts.chinacloudapi.cn/";
    private final JwtClaimValidator<String> validator;
    private final AadTrustedIssuerRepository trustedIssuerRepo;

    public AadJwtIssuerValidator() {
        this(null);
    }

    public AadJwtIssuerValidator(AadTrustedIssuerRepository aadTrustedIssuerRepository) {
        this.trustedIssuerRepo = aadTrustedIssuerRepository;
        this.validator = new JwtClaimValidator("iss", this.trustedIssuerRepoValidIssuer());
    }

    private Predicate<String> trustedIssuerRepoValidIssuer() {
        return iss -> {
            if (iss == null) {
                return false;
            }
            if (this.trustedIssuerRepo == null) {
                return iss.startsWith(LOGIN_MICROSOFT_ONLINE_ISSUER) || iss.startsWith(STS_WINDOWS_ISSUER) || iss.startsWith(STS_CHINA_CLOUD_API_ISSUER);
            }
            return this.trustedIssuerRepo.getTrustedIssuers().contains(iss);
        };
    }

    public OAuth2TokenValidatorResult validate(Jwt token) {
        Assert.notNull((Object)token, (String)"token cannot be null");
        return this.validator.validate(token);
    }
}

