/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation.oauth2;

import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequestEntityConverter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public abstract class AbstractOAuth2AuthorizationCodeGrantRequestEntityConverter
extends OAuth2AuthorizationCodeGrantRequestEntityConverter {
    protected abstract String getApplicationId();

    public RequestEntity<?> convert(OAuth2AuthorizationCodeGrantRequest request) {
        RequestEntity requestEntity = super.convert((AbstractOAuth2AuthorizationGrantRequest)request);
        Assert.notNull((Object)requestEntity, (String)"requestEntity can not be null");
        HttpHeaders httpHeaders = this.getHttpHeaders();
        Optional.of(requestEntity).map(HttpEntity::getHeaders).ifPresent(arg_0 -> ((HttpHeaders)httpHeaders).putAll(arg_0));
        MultiValueMap body = (MultiValueMap)requestEntity.getBody();
        Assert.notNull((Object)body, (String)"body can not be null");
        Optional.ofNullable(this.getHttpBody(request)).ifPresent(arg_0 -> body.putAll(arg_0));
        return new RequestEntity((Object)body, (MultiValueMap)httpHeaders, requestEntity.getMethod(), requestEntity.getUrl());
    }

    public HttpHeaders getHttpHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.put("x-client-SKU", Collections.singletonList(this.getApplicationId()));
        httpHeaders.put("x-client-VER", Collections.singletonList(AzureSpringIdentifier.VERSION));
        httpHeaders.put("client-request-id", Collections.singletonList(UUID.randomUUID().toString()));
        return httpHeaders;
    }

    public MultiValueMap<String, String> getHttpBody(OAuth2AuthorizationCodeGrantRequest request) {
        return null;
    }
}

