/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation.jwt;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class AadJwtDecoderProviderConfiguration {
    private static final String OIDC_METADATA_PATH = "/.well-known/openid-configuration";
    private static final RestTemplate REST = new RestTemplate();
    private static final ParameterizedTypeReference<Map<String, Object>> TYPE_REFERENCE = new ParameterizedTypeReference<Map<String, Object>>(){};

    public static Map<String, Object> getConfigurationForOidcIssuerLocation(String oidcIssuerLocation) {
        return AadJwtDecoderProviderConfiguration.getConfiguration(oidcIssuerLocation, AadJwtDecoderProviderConfiguration.oidc(URI.create(oidcIssuerLocation)));
    }

    private static Map<String, Object> getConfiguration(String issuer, URI ... uris) {
        String errorMessage = "Unable to resolve the Configuration with the provided Issuer of " + issuer;
        for (URI uri : uris) {
            try {
                RequestEntity request = RequestEntity.get((URI)uri).build();
                ResponseEntity response = REST.exchange(request, TYPE_REFERENCE);
                Map configuration = (Map)response.getBody();
                if (configuration == null) {
                    throw new IllegalArgumentException("The configuration must not be null");
                }
                if (configuration.get("jwks_uri") == null) {
                    throw new IllegalArgumentException("The public JWK set URI must not be null");
                }
                return configuration;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (e instanceof HttpClientErrorException && ((HttpClientErrorException)e).getStatusCode().is4xxClientError()) continue;
                throw new IllegalArgumentException(errorMessage, e);
            }
        }
        throw new IllegalArgumentException(errorMessage);
    }

    private static URI oidc(URI issuer) {
        return UriComponentsBuilder.fromUri((URI)issuer).replacePath(issuer.getPath() + OIDC_METADATA_PATH).build(Collections.emptyMap());
    }
}

