/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.spring.cloud.appconfiguration.config.implementation.configuration.WatchedConfigurationSettings;
import java.time.Instant;
import java.util.List;

class State {
    private final List<ConfigurationSetting> watchKeys;
    private final List<WatchedConfigurationSettings> collectionWatchKeys;
    private final Instant nextRefreshCheck;
    private final String originEndpoint;
    private int refreshAttempt;
    private final int refreshInterval;

    State(List<ConfigurationSetting> watchKeys, int refreshInterval, String originEndpoint) {
        this(watchKeys, null, refreshInterval, originEndpoint);
    }

    State(List<ConfigurationSetting> watchKeys, List<WatchedConfigurationSettings> collectionWatchKeys, int refreshInterval, String originEndpoint) {
        this(watchKeys, collectionWatchKeys, refreshInterval, originEndpoint, Instant.now().plusSeconds(refreshInterval), 1);
    }

    State(State oldState, Instant newRefresh) {
        this(oldState, newRefresh, oldState.getRefreshAttempt());
    }

    State(State oldState, Instant newRefresh, int refreshAttempt) {
        this(oldState.getWatchKeys(), oldState.getCollectionWatchKeys(), oldState.getRefreshInterval(), oldState.getOriginEndpoint(), newRefresh, refreshAttempt);
    }

    private State(List<ConfigurationSetting> watchKeys, List<WatchedConfigurationSettings> collectionWatchKeys, int refreshInterval, String originEndpoint, Instant nextRefreshCheck, int refreshAttempt) {
        this.watchKeys = watchKeys;
        this.collectionWatchKeys = collectionWatchKeys;
        this.refreshInterval = refreshInterval;
        this.nextRefreshCheck = nextRefreshCheck;
        this.originEndpoint = originEndpoint;
        this.refreshAttempt = refreshAttempt;
    }

    public List<ConfigurationSetting> getWatchKeys() {
        return this.watchKeys;
    }

    public List<WatchedConfigurationSettings> getCollectionWatchKeys() {
        return this.collectionWatchKeys;
    }

    public Instant getNextRefreshCheck() {
        return this.nextRefreshCheck;
    }

    public String getOriginEndpoint() {
        return this.originEndpoint;
    }

    public int getRefreshAttempt() {
        return this.refreshAttempt;
    }

    public State incrementRefreshAttempt() {
        ++this.refreshAttempt;
        return this;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }
}

