/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.spring.cloud.appconfiguration.config.AppConfigurationStoreHealth;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientsBuilder;
import com.azure.spring.cloud.appconfiguration.config.implementation.BackoffTimeCalculator;
import com.azure.spring.cloud.appconfiguration.config.implementation.autofailover.ReplicaLookUp;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.ConfigStore;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.FeatureFlagStore;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private final String originEndpoint;
    private List<AppConfigurationReplicaClient> clients;
    private final Map<String, AppConfigurationReplicaClient> autoFailoverClients;
    private String currentReplica;
    private AppConfigurationStoreHealth health;
    private final AppConfigurationReplicaClientsBuilder clientBuilder;
    private final ConfigStore configStore;
    private final ReplicaLookUp replicaLookUp;
    private List<AppConfigurationReplicaClient> activeClients;
    private String lastActiveClient;

    ConnectionManager(AppConfigurationReplicaClientsBuilder clientBuilder, ConfigStore configStore, ReplicaLookUp replicaLookUp) {
        this.clientBuilder = clientBuilder;
        this.configStore = configStore;
        this.originEndpoint = configStore.getEndpoint();
        this.health = AppConfigurationStoreHealth.NOT_LOADED;
        this.currentReplica = configStore.getEndpoint();
        this.autoFailoverClients = new HashMap<String, AppConfigurationReplicaClient>();
        this.replicaLookUp = replicaLookUp;
        this.activeClients = new ArrayList<AppConfigurationReplicaClient>();
        this.lastActiveClient = "";
    }

    AppConfigurationStoreHealth getHealth() {
        return this.health;
    }

    void setCurrentClient(String replicaEndpoint) {
        this.currentReplica = replicaEndpoint;
    }

    String getMainEndpoint() {
        return this.originEndpoint;
    }

    AppConfigurationReplicaClient getNextActiveClient(boolean useLastActive) {
        if (this.activeClients.isEmpty()) {
            this.lastActiveClient = "";
            return null;
        }
        if (useLastActive) {
            List<AppConfigurationReplicaClient> clients = this.getAvailableClients();
            for (AppConfigurationReplicaClient client : clients) {
                if (!client.getEndpoint().equals(this.lastActiveClient)) continue;
                return client;
            }
        }
        if (!this.configStore.isLoadBalancingEnabled()) {
            if (!this.activeClients.isEmpty()) {
                return this.activeClients.get(0);
            }
            return null;
        }
        AppConfigurationReplicaClient nextClient = this.activeClients.remove(0);
        this.lastActiveClient = nextClient.getEndpoint();
        return nextClient;
    }

    void findActiveClients() {
        this.activeClients = this.getAvailableClients();
        if (!this.configStore.isLoadBalancingEnabled() || this.lastActiveClient.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.activeClients.size(); ++i) {
            AppConfigurationReplicaClient client = this.activeClients.get(i);
            if (!client.getEndpoint().equals(this.lastActiveClient)) continue;
            int swapPoint = (i + 1) % this.activeClients.size();
            ArrayList<AppConfigurationReplicaClient> rotatedClients = new ArrayList<AppConfigurationReplicaClient>();
            rotatedClients.addAll(this.activeClients.subList(swapPoint, this.activeClients.size()));
            rotatedClients.addAll(this.activeClients.subList(0, swapPoint));
            this.activeClients = rotatedClients;
            return;
        }
    }

    public List<AppConfigurationReplicaClient> getAvailableClients() {
        List<String> autoFailoverEndpoints;
        if (this.clients == null) {
            this.clients = this.clientBuilder.buildClients(this.configStore);
            if (this.clients.isEmpty()) {
                this.health = AppConfigurationStoreHealth.NOT_LOADED;
            }
        }
        ArrayList<AppConfigurationReplicaClient> availableClients = new ArrayList<AppConfigurationReplicaClient>();
        if (this.clients.size() == 1 && !this.configStore.isLoadBalancingEnabled()) {
            if (this.clients.get(0).getBackoffEndTime().isBefore(Instant.now())) {
                availableClients.add(this.clients.get(0));
            }
        } else if (this.clients.size() > 0 && !this.configStore.isLoadBalancingEnabled()) {
            for (AppConfigurationReplicaClient replicaClient : this.clients) {
                if (!replicaClient.getBackoffEndTime().isBefore(Instant.now())) continue;
                LOGGER.debug("Using Client: " + replicaClient.getEndpoint());
                availableClients.add(replicaClient);
            }
        } else if (this.configStore.isLoadBalancingEnabled()) {
            for (AppConfigurationReplicaClient client : this.clients) {
                if (!client.getBackoffEndTime().isBefore(Instant.now())) continue;
                availableClients.add(client);
            }
        }
        if ((availableClients.size() == 0 || this.configStore.isLoadBalancingEnabled()) && (autoFailoverEndpoints = this.replicaLookUp.getAutoFailoverEndpoints(this.configStore.getEndpoint())).size() > 0) {
            for (String failoverEndpoint : autoFailoverEndpoints) {
                AppConfigurationReplicaClient client = this.autoFailoverClients.get(failoverEndpoint);
                if (client == null) {
                    client = this.clientBuilder.buildClient(failoverEndpoint, this.configStore);
                    this.autoFailoverClients.put(failoverEndpoint, client);
                }
                if (!client.getBackoffEndTime().isBefore(Instant.now())) continue;
                availableClients.add(client);
                break;
            }
        }
        if (this.clients.size() > 0 && availableClients.size() == 0) {
            this.health = AppConfigurationStoreHealth.DOWN;
        } else if (this.clients.size() > 0) {
            this.health = AppConfigurationStoreHealth.UP;
        }
        return availableClients;
    }

    void backoffClient(String endpoint) {
        for (AppConfigurationReplicaClient client : this.clients) {
            if (!client.getEndpoint().equals(endpoint)) continue;
            int failedAttempt = client.getFailedAttempts();
            long backoffTime = BackoffTimeCalculator.calculateBackoff(failedAttempt);
            client.updateBackoffEndTime(Instant.now().plusNanos(backoffTime));
            this.activeClients.removeIf(removeClient -> removeClient.getEndpoint().equals(endpoint));
            return;
        }
        int failedAttempt = this.autoFailoverClients.get(endpoint).getFailedAttempts();
        long backoffTime = BackoffTimeCalculator.calculateBackoff(failedAttempt);
        this.autoFailoverClients.get(endpoint).updateBackoffEndTime(Instant.now().plusNanos(backoffTime));
    }

    void updateSyncToken(String endpoint, String syncToken) {
        this.clients.stream().filter(client -> client.getEndpoint().equals(endpoint)).findFirst().ifPresent(client -> client.updateSyncToken(syncToken));
        this.autoFailoverClients.values().stream().filter(client -> client.getEndpoint().equals(endpoint)).findFirst().ifPresent(client -> client.updateSyncToken(syncToken));
    }

    AppConfigurationStoreMonitoring getMonitoring() {
        return this.configStore.getMonitoring();
    }

    FeatureFlagStore getFeatureFlagStore() {
        return this.configStore.getFeatureFlags();
    }
}

