/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.core.util.Context;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationApplicationSettingPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationKeyVaultClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.FeatureFlagClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.configuration.WatchedConfigurationSettings;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;

final class AppConfigurationSnapshotPropertySource
extends AppConfigurationApplicationSettingPropertySource {
    private final String snapshotName;
    private final FeatureFlagClient featureFlagClient;
    private List<ConfigurationSetting> featureFlagsList = new ArrayList<ConfigurationSetting>();

    AppConfigurationSnapshotPropertySource(String name, AppConfigurationReplicaClient replicaClient, AppConfigurationKeyVaultClientFactory keyVaultClientFactory, String snapshotName, FeatureFlagClient featureFlagClient) {
        super(name, replicaClient, keyVaultClientFactory, null, null);
        this.snapshotName = snapshotName;
        this.featureFlagClient = featureFlagClient;
    }

    @Override
    public void initProperties(List<String> trim, Context context) throws InvalidConfigurationPropertyValueException {
        this.processConfigurationSettings(this.replicaClient.listSettingSnapshot(this.snapshotName, context), null, trim);
        WatchedConfigurationSettings featureFlags = new WatchedConfigurationSettings(null, this.featureFlagsList);
        this.featureFlagClient.proccessFeatureFlags(featureFlags, this.replicaClient.getEndpoint());
    }

    @Override
    void handleFeatureFlag(String key, FeatureFlagConfigurationSetting setting, List<String> trimStrings) {
        this.featureFlagsList.add((ConfigurationSetting)setting);
    }
}

