/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.MatchConditions;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.util.Context;
import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.ConfigurationSnapshot;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.data.appconfiguration.models.SnapshotComposition;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationStatusException;
import com.azure.spring.cloud.appconfiguration.config.implementation.NormalizeNull;
import com.azure.spring.cloud.appconfiguration.config.implementation.configuration.WatchedConfigurationSettings;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

class AppConfigurationReplicaClient {
    private static final long INITIAL_BACKOFF_OFFSET_MS = 1L;
    private static final int HTTP_NOT_MODIFIED = 304;
    private final String endpoint;
    private final String originClient;
    private final ConfigurationClient client;
    private Instant backoffEndTime;
    private int failedAttempts;

    AppConfigurationReplicaClient(String endpoint, String originClient, ConfigurationClient client) {
        this.endpoint = endpoint;
        this.originClient = originClient;
        this.client = client;
        this.backoffEndTime = Instant.now().minusMillis(1L);
        this.failedAttempts = 0;
    }

    Instant getBackoffEndTime() {
        return this.backoffEndTime;
    }

    void updateBackoffEndTime(Instant backoffEndTime) {
        this.backoffEndTime = backoffEndTime;
        ++this.failedAttempts;
    }

    int getFailedAttempts() {
        return this.failedAttempts;
    }

    String getEndpoint() {
        return this.endpoint;
    }

    String getOriginClient() {
        return this.originClient;
    }

    ConfigurationSetting getWatchKey(String key, String label, Context context) throws HttpResponseException {
        try {
            ConfigurationSetting selector = new ConfigurationSetting().setKey(key).setLabel(label);
            ConfigurationSetting watchKey = NormalizeNull.normalizeNullLabel((ConfigurationSetting)this.client.getConfigurationSettingWithResponse(selector, null, false, context).getValue());
            this.failedAttempts = 0;
            return watchKey;
        }
        catch (HttpResponseException e) {
            throw this.handleHttpResponseException(e);
        }
        catch (UncheckedIOException e) {
            throw new AppConfigurationStatusException(e.getMessage(), null, null);
        }
    }

    List<ConfigurationSetting> listSettings(SettingSelector settingSelector, Context context) throws HttpResponseException {
        ArrayList<ConfigurationSetting> configurationSettings = new ArrayList<ConfigurationSetting>();
        try {
            PagedIterable settings = this.client.listConfigurationSettings(settingSelector, context);
            settings.forEach(setting -> configurationSettings.add(NormalizeNull.normalizeNullLabel(setting)));
            this.failedAttempts = 0;
            return configurationSettings;
        }
        catch (HttpResponseException e) {
            throw this.handleHttpResponseException(e);
        }
        catch (UncheckedIOException e) {
            throw new AppConfigurationStatusException(e.getMessage(), null, null);
        }
    }

    WatchedConfigurationSettings loadWatchedSettings(SettingSelector settingSelector, Context context) {
        ArrayList<ConfigurationSetting> configurationSettings = new ArrayList<ConfigurationSetting>();
        ArrayList checks = new ArrayList();
        try {
            this.client.listConfigurationSettings(settingSelector, context).streamByPage().forEach(pagedResponse -> {
                checks.add(new MatchConditions().setIfNoneMatch(pagedResponse.getHeaders().getValue(HttpHeaderName.ETAG)));
                for (ConfigurationSetting setting : pagedResponse.getValue()) {
                    configurationSettings.add(NormalizeNull.normalizeNullLabel(setting));
                }
            });
            this.failedAttempts = 0;
            settingSelector.setMatchConditions(checks);
            return new WatchedConfigurationSettings(settingSelector, configurationSettings);
        }
        catch (HttpResponseException e) {
            throw this.handleHttpResponseException(e);
        }
        catch (UncheckedIOException e) {
            throw new AppConfigurationStatusException(e.getMessage(), null, null);
        }
    }

    WatchedConfigurationSettings listFeatureFlags(SettingSelector settingSelector, Context context) throws HttpResponseException {
        ArrayList<ConfigurationSetting> configurationSettings = new ArrayList<ConfigurationSetting>();
        ArrayList checks = new ArrayList();
        try {
            this.client.listConfigurationSettings(settingSelector, context).streamByPage().forEach(pagedResponse -> {
                checks.add(new MatchConditions().setIfNoneMatch(pagedResponse.getHeaders().getValue(HttpHeaderName.ETAG)));
                for (ConfigurationSetting featureFlag : pagedResponse.getValue()) {
                    configurationSettings.add((ConfigurationSetting)((FeatureFlagConfigurationSetting)NormalizeNull.normalizeNullLabel(featureFlag)));
                }
            });
            this.failedAttempts = 0;
            settingSelector.setMatchConditions(checks);
            return new WatchedConfigurationSettings(settingSelector, configurationSettings);
        }
        catch (HttpResponseException e) {
            throw this.handleHttpResponseException(e);
        }
        catch (UncheckedIOException e) {
            throw new AppConfigurationStatusException(e.getMessage(), null, null);
        }
    }

    List<ConfigurationSetting> listSettingSnapshot(String snapshotName, Context context) {
        ArrayList<ConfigurationSetting> configurationSettings = new ArrayList<ConfigurationSetting>();
        try {
            ConfigurationSnapshot snapshot = (ConfigurationSnapshot)this.client.getSnapshotWithResponse(snapshotName, null, context).getValue();
            if (!SnapshotComposition.KEY.equals((Object)snapshot.getSnapshotComposition())) {
                throw new IllegalArgumentException("Snapshot " + snapshotName + " needs to be of type Key.");
            }
            PagedIterable settings = this.client.listConfigurationSettingsForSnapshot(snapshotName);
            this.failedAttempts = 0;
            settings.forEach(setting -> configurationSettings.add(NormalizeNull.normalizeNullLabel(setting)));
            return configurationSettings;
        }
        catch (HttpResponseException e) {
            throw this.handleHttpResponseException(e);
        }
        catch (UncheckedIOException e) {
            throw new AppConfigurationStatusException(e.getMessage(), null, null);
        }
    }

    boolean checkWatchKeys(SettingSelector settingSelector, Context context) {
        List<PagedResponse> results = this.client.listConfigurationSettings(settingSelector, context).streamByPage().filter(pagedResponse -> pagedResponse.getStatusCode() != 304).toList();
        return results.size() > 0;
    }

    void updateSyncToken(String syncToken) {
        if (StringUtils.hasText((String)syncToken)) {
            this.client.updateSyncToken(syncToken);
        }
    }

    private HttpResponseException handleHttpResponseException(HttpResponseException e) {
        int statusCode;
        if (e.getResponse() != null && ((statusCode = e.getResponse().getStatusCode()) == HttpResponseStatus.TOO_MANY_REQUESTS.code() || statusCode == HttpResponseStatus.REQUEST_TIMEOUT.code() || statusCode >= HttpResponseStatus.INTERNAL_SERVER_ERROR.code())) {
            return new AppConfigurationStatusException(e.getMessage(), e.getResponse(), e.getValue());
        }
        return e;
    }
}

