/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.autofailover;

class SRVRecord {
    private final int priority;
    private final int weight;
    private final int port;
    private final String target;
    private static final String PROTOCAL = "https://";

    SRVRecord(String[] record) {
        this.priority = Integer.valueOf(record[0]);
        this.weight = Integer.valueOf(record[1]);
        this.port = Integer.valueOf(record[2]);
        this.target = record[3].substring(0, record[3].length() - 1);
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public String getTarget() {
        return this.target;
    }

    public String getEndpoint() {
        return PROTOCAL + this.target;
    }

    int compareTo(SRVRecord record) {
        if (this.priority > record.getPriority()) {
            return 1;
        }
        if (record.getPriority() > this.priority) {
            return -1;
        }
        if (this.weight > record.getWeight()) {
            return 1;
        }
        if (record.getWeight() > this.weight) {
            return -1;
        }
        return 0;
    }
}

