/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.spring.cloud.appconfiguration.config.ConfigurationClientCustomizer;
import com.azure.spring.cloud.appconfiguration.config.KeyVaultSecretProvider;
import com.azure.spring.cloud.appconfiguration.config.SecretClientCustomizer;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationKeyVaultClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientsBuilder;
import com.azure.spring.cloud.appconfiguration.config.implementation.autofailover.ReplicaLookUp;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.appconfiguration.AzureAppConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.secrets.properties.AzureKeyVaultSecretProperties;
import com.azure.spring.cloud.autoconfigure.implementation.properties.core.AbstractAzureHttpConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.properties.core.authentication.TokenCredentialConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.properties.utils.AzureGlobalPropertiesUtils;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.appconfiguration.ConfigurationClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.appconfiguration.ConfigurationClientProperties;
import com.azure.spring.cloud.service.implementation.keyvault.secrets.SecretClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.keyvault.secrets.SecretClientProperties;
import org.springframework.boot.bootstrap.BootstrapContext;
import org.springframework.boot.bootstrap.BootstrapRegistry;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.util.StringUtils;

class AzureAppConfigurationBootstrapRegistrar {
    AzureAppConfigurationBootstrapRegistrar() {
    }

    static void register(ConfigDataLocationResolverContext context, Binder binder, AppConfigurationProperties properties, ReplicaLookUp replicaLookup) {
        AzureGlobalProperties globalProperties = (AzureGlobalProperties)binder.bind("spring.cloud.azure", Bindable.of(AzureGlobalProperties.class)).orElseGet(AzureGlobalProperties::new);
        AzureAppConfigurationProperties appConfigurationProperties = (AzureAppConfigurationProperties)binder.bind("spring.cloud.azure.appconfiguration", Bindable.of(AzureAppConfigurationProperties.class)).orElseGet(AzureAppConfigurationProperties::new);
        AzureAppConfigurationProperties loadedProperties = (AzureAppConfigurationProperties)AzureGlobalPropertiesUtils.loadProperties((AzureGlobalProperties)globalProperties, (AzureProperties)appConfigurationProperties);
        boolean isCredentialConfigured = AzureAppConfigurationBootstrapRegistrar.isCredentialConfigured((AbstractAzureHttpConfigurationProperties)loadedProperties);
        AppConfigurationKeyVaultClientFactory keyVaultClientFactory = AzureAppConfigurationBootstrapRegistrar.appConfigurationKeyVaultClientFactory(context, binder, isCredentialConfigured);
        AppConfigurationReplicaClientsBuilder replicaClientsBuilder = AzureAppConfigurationBootstrapRegistrar.replicaClientBuilder(context, keyVaultClientFactory, loadedProperties, isCredentialConfigured);
        context.getBootstrapContext().registerIfAbsent(AppConfigurationKeyVaultClientFactory.class, BootstrapRegistry.InstanceSupplier.from(() -> keyVaultClientFactory));
        context.getBootstrapContext().registerIfAbsent(AppConfigurationReplicaClientFactory.class, BootstrapRegistry.InstanceSupplier.from(() -> AzureAppConfigurationBootstrapRegistrar.buildClientFactory(replicaClientsBuilder, properties, replicaLookup)));
    }

    private static AppConfigurationKeyVaultClientFactory appConfigurationKeyVaultClientFactory(ConfigDataLocationResolverContext context, Binder binder, boolean isCredentialConfigured) throws IllegalArgumentException {
        SecretClientCustomizer customizer = (SecretClientCustomizer)context.getBootstrapContext().getOrElse(SecretClientCustomizer.class, null);
        KeyVaultSecretProvider secretProvider = (KeyVaultSecretProvider)context.getBootstrapContext().getOrElse(KeyVaultSecretProvider.class, null);
        AzureKeyVaultSecretProperties secretClientProperties = (AzureKeyVaultSecretProperties)binder.bind("spring.cloud.azure.keyvault.secret", Bindable.of(AzureKeyVaultSecretProperties.class)).orElseGet(AzureKeyVaultSecretProperties::new);
        SecretClientBuilderFactory secretClientBuilderFactory = new SecretClientBuilderFactory((SecretClientProperties)secretClientProperties);
        context.getBootstrapContext().registerIfAbsent(SecretClientBuilderFactory.class, BootstrapRegistry.InstanceSupplier.from(() -> secretClientBuilderFactory));
        return new AppConfigurationKeyVaultClientFactory(customizer, secretProvider, secretClientBuilderFactory, isCredentialConfigured);
    }

    private static AppConfigurationReplicaClientFactory buildClientFactory(AppConfigurationReplicaClientsBuilder clientBuilder, AppConfigurationProperties properties, ReplicaLookUp replicaLookup) {
        return new AppConfigurationReplicaClientFactory(clientBuilder, properties.getStores(), replicaLookup);
    }

    private static AppConfigurationReplicaClientsBuilder replicaClientBuilder(ConfigDataLocationResolverContext context, AppConfigurationKeyVaultClientFactory keyVaultClientFactory, AzureAppConfigurationProperties properties, boolean isCredentialConfigured) {
        BootstrapRegistry.InstanceSupplier customizer = context.getBootstrapContext().getRegisteredInstanceSupplier(AzureServiceClientBuilderCustomizer.class);
        ConfigurationClientBuilderFactory clientFactory = (ConfigurationClientBuilderFactory)context.getBootstrapContext().getOrElseSupply(ConfigurationClientBuilderFactory.class, () -> {
            ConfigurationClientBuilderFactory factory = new ConfigurationClientBuilderFactory((ConfigurationClientProperties)properties);
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_APP_CONFIG);
            if (customizer != null) {
                factory.addBuilderCustomizer((AzureServiceClientBuilderCustomizer)customizer.get((BootstrapContext)context.getBootstrapContext()));
            }
            return factory;
        });
        if (customizer != null) {
            clientFactory.addBuilderCustomizer((AzureServiceClientBuilderCustomizer)customizer.get((BootstrapContext)context.getBootstrapContext()));
        }
        BootstrapRegistry.InstanceSupplier configurationClientCustomizer = context.getBootstrapContext().getRegisteredInstanceSupplier(ConfigurationClientCustomizer.class);
        ConfigurationClientCustomizer clientCustomizer = null;
        if (configurationClientCustomizer != null) {
            clientCustomizer = (ConfigurationClientCustomizer)configurationClientCustomizer.get((BootstrapContext)context.getBootstrapContext());
        }
        return new AppConfigurationReplicaClientsBuilder(clientFactory, clientCustomizer, isCredentialConfigured, keyVaultClientFactory.isConfigured());
    }

    private static boolean isCredentialConfigured(AbstractAzureHttpConfigurationProperties properties) {
        if (properties.getCredential() != null) {
            TokenCredentialConfigurationProperties tokenProps = properties.getCredential();
            if (StringUtils.hasText((String)tokenProps.getClientCertificatePassword())) {
                return true;
            }
            if (StringUtils.hasText((String)tokenProps.getClientCertificatePath())) {
                return true;
            }
            if (StringUtils.hasText((String)tokenProps.getClientId())) {
                return true;
            }
            if (StringUtils.hasText((String)tokenProps.getClientSecret())) {
                return true;
            }
            if (StringUtils.hasText((String)tokenProps.getUsername())) {
                return true;
            }
            if (StringUtils.hasText((String)tokenProps.getPassword())) {
                return true;
            }
        }
        return false;
    }
}

