/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.spring.cloud.appconfiguration.config.implementation.AzureAppConfigDataResource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AzureAppConfigurationBootstrapRegistrar;
import com.azure.spring.cloud.appconfiguration.config.implementation.autofailover.ReplicaLookUp;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationProperties;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.ConfigStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.springframework.boot.bootstrap.BootstrapRegistry;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.util.StringUtils;

public class AzureAppConfigDataLocationResolver
implements ConfigDataLocationResolver<AzureAppConfigDataResource> {
    private static final Log LOGGER = new DeferredLog();
    public static final String PREFIX = "azureAppConfiguration";
    private static final AtomicBoolean START_UP = new AtomicBoolean(true);

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        if (!location.hasPrefix(PREFIX)) {
            return false;
        }
        return this.hasValidStoreConfiguration(context.getBinder());
    }

    private boolean hasValidStoreConfiguration(Binder binder) {
        String configPrefix = "spring.cloud.azure.appconfiguration.stores[0].";
        return this.hasNonEmptyProperty(binder, configPrefix + "endpoint") || this.hasNonEmptyProperty(binder, configPrefix + "connection-string") || this.hasNonEmptyProperty(binder, configPrefix + "endpoints") || this.hasNonEmptyProperty(binder, configPrefix + "connection-strings");
    }

    private boolean hasNonEmptyProperty(Binder binder, String propertyPath) {
        return StringUtils.hasText((String)((String)binder.bind(propertyPath, String.class).orElse((Object)"")));
    }

    public List<AzureAppConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        return Collections.emptyList();
    }

    public List<AzureAppConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        AppConfigurationProperties properties = this.loadProperties(resolverContext);
        ArrayList<AzureAppConfigDataResource> locations = new ArrayList<AzureAppConfigDataResource>();
        if (properties.getStores() == null || properties.getStores().isEmpty()) {
            throw new ConfigDataLocationNotFoundException(location, "No Azure App Configuration stores are configured. Please check your application properties.", (Throwable)new IllegalStateException("No stores configured"));
        }
        for (ConfigStore store : properties.getStores()) {
            locations.add(new AzureAppConfigDataResource(properties.isEnabled(), store, profiles, START_UP.get(), properties.getRefreshInterval()));
        }
        START_UP.set(false);
        return locations;
    }

    protected AppConfigurationProperties loadProperties(ConfigDataLocationResolverContext context) {
        Binder binder = context.getBinder();
        BindHandler bindHandler = this.getBindHandler(context);
        AppConfigurationProperties properties = (AppConfigurationProperties)binder.bind("spring.cloud.azure.appconfiguration", Bindable.of(AppConfigurationProperties.class), bindHandler).get();
        properties.validateAndInit();
        ReplicaLookUp replicaLookup = null;
        try {
            replicaLookup = new ReplicaLookUp(properties);
            replicaLookup.updateAutoFailoverEndpoints();
            context.getBootstrapContext().registerIfAbsent(ReplicaLookUp.class, BootstrapRegistry.InstanceSupplier.of((Object)replicaLookup));
        }
        catch (NamingException e) {
            LOGGER.info((Object)"Failed to find DNS Entry for config store while looking for replicas.");
        }
        AzureAppConfigurationBootstrapRegistrar.register(context, binder, properties, replicaLookup);
        return properties;
    }

    private BindHandler getBindHandler(ConfigDataLocationResolverContext context) {
        return (BindHandler)context.getBootstrapContext().getOrElse(BindHandler.class, null);
    }
}

