/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import java.time.Instant;
import java.util.List;

class State {
    private final List<ConfigurationSetting> watchKeys;
    private final Instant nextRefreshCheck;
    private final String originEndpoint;
    private Integer refreshAttempt;
    private final int refreshInterval;

    State(List<ConfigurationSetting> watchKeys, int refreshInterval, String originEndpoint) {
        this.watchKeys = watchKeys;
        this.refreshInterval = refreshInterval;
        this.nextRefreshCheck = Instant.now().plusSeconds(refreshInterval);
        this.originEndpoint = originEndpoint;
        this.refreshAttempt = 1;
    }

    State(State oldState, Instant newRefresh) {
        this.watchKeys = oldState.getWatchKeys();
        this.refreshInterval = oldState.getRefreshInterval();
        this.nextRefreshCheck = newRefresh;
        this.originEndpoint = oldState.getOriginEndpoint();
        this.refreshAttempt = oldState.getRefreshAttempt();
    }

    public List<ConfigurationSetting> getWatchKeys() {
        return this.watchKeys;
    }

    public Instant getNextRefreshCheck() {
        return this.nextRefreshCheck;
    }

    public String getOriginEndpoint() {
        return this.originEndpoint;
    }

    public Integer getRefreshAttempt() {
        return this.refreshAttempt;
    }

    public void incrementRefreshAttempt() {
        this.refreshAttempt = this.refreshAttempt + 1;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }
}

