/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.core.util.Context;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.core.env.EnumerablePropertySource;

abstract class AppConfigurationPropertySource
extends EnumerablePropertySource<AppConfigurationReplicaClient> {
    protected final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    protected final AppConfigurationReplicaClient replicaClient;

    AppConfigurationPropertySource(String name, AppConfigurationReplicaClient replicaClient) {
        super(name, (Object)replicaClient);
        this.replicaClient = replicaClient;
    }

    public String[] getPropertyNames() {
        return (String[])this.properties.keySet().toArray(String[]::new);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    protected static String getLabelName(String[] labelFilters) {
        if (labelFilters == null || labelFilters.length == 0) {
            return "";
        }
        return String.join((CharSequence)",", labelFilters);
    }

    protected abstract void initProperties(List<String> var1, Context var2) throws InvalidConfigurationPropertyValueException;
}

