/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.http.policy;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.spring.cloud.appconfiguration.config.implementation.http.policy.FeatureFlagTracing;
import com.azure.spring.cloud.appconfiguration.config.implementation.http.policy.TracingInfo;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public final class BaseAppConfigurationPolicy
implements HttpPipelinePolicy {
    private static final String PACKAGE_NAME = BaseAppConfigurationPolicy.class.getPackage().getImplementationTitle();
    private static final String USER_AGENT = String.format("%s/%s", StringUtils.replace((String)PACKAGE_NAME, (String)" ", (String)""), BaseAppConfigurationPolicy.class.getPackage().getImplementationVersion());
    private final TracingInfo tracingInfo;

    public BaseAppConfigurationPolicy(TracingInfo tracingInfo) {
        this.tracingInfo = tracingInfo;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        Boolean watchRequests = context.getData("refresh").orElse(false);
        Boolean pushRefresh = context.getData("PushRefresh").orElse(false);
        FeatureFlagTracing ffTracing = context.getData("FeatureFlagTracing").orElse(null);
        HttpHeaders headers = context.getHttpRequest().getHeaders();
        String sdkUserAgent = headers.get(HttpHeaderName.USER_AGENT).getValue();
        headers.set(HttpHeaderName.USER_AGENT, USER_AGENT + " " + sdkUserAgent);
        headers.set(HttpHeaderName.fromString((String)"Correlation-Context"), this.tracingInfo.getValue(watchRequests, pushRefresh, ffTracing));
        return next.process();
    }
}

